/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.Vector;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.AuthorizationDataEntry;
import sun.security.krb5.internal.ccache.CCacheOutputStream;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class AuthorizationData
implements Cloneable {
    private AuthorizationDataEntry[] entry = null;

    private AuthorizationData() {
    }

    public AuthorizationData(AuthorizationDataEntry[] new_entries) throws IOException {
        if (new_entries != null) {
            this.entry = new AuthorizationDataEntry[new_entries.length];
            for (int i = 0; i < new_entries.length; ++i) {
                if (new_entries[i] == null) {
                    throw new IOException("Cannot create an AuthorizationData");
                }
                this.entry[i] = (AuthorizationDataEntry)new_entries[i].clone();
            }
        }
    }

    public AuthorizationData(AuthorizationDataEntry new_entry) {
        this.entry = new AuthorizationDataEntry[1];
        this.entry[0] = new_entry;
    }

    public Object clone() {
        AuthorizationData new_authorizationData = new AuthorizationData();
        if (this.entry != null) {
            new_authorizationData.entry = new AuthorizationDataEntry[this.entry.length];
            for (int i = 0; i < this.entry.length; ++i) {
                new_authorizationData.entry[i] = (AuthorizationDataEntry)this.entry[i].clone();
            }
        }
        return new_authorizationData;
    }

    public AuthorizationData(DerValue der) throws Asn1Exception, IOException {
        Vector<AuthorizationDataEntry> v = new Vector<AuthorizationDataEntry>();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (der.getData().available() > 0) {
            v.addElement(new AuthorizationDataEntry(der.getData().getDerValue()));
        }
        if (v.size() > 0) {
            this.entry = new AuthorizationDataEntry[v.size()];
            v.copyInto(this.entry);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerValue[] der = new DerValue[this.entry.length];
        for (int i = 0; i < this.entry.length; ++i) {
            der[i] = new DerValue(this.entry[i].asn1Encode());
        }
        bytes.putSequence(der);
        return bytes.toByteArray();
    }

    public static AuthorizationData parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new AuthorizationData(subDer);
    }

    public void writeAuth(CCacheOutputStream cos) throws IOException {
        for (int i = 0; i < this.entry.length; ++i) {
            this.entry[i].writeEntry(cos);
        }
    }

    public String toString() {
        String retVal = "AuthorizationData:\n";
        for (int i = 0; i < this.entry.length; ++i) {
            retVal = retVal + this.entry[i].toString();
        }
        return retVal;
    }
}

