/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.crypto.Des3;
import sun.security.krb5.internal.crypto.EType;

public final class Des3CbcHmacSha1KdEType
extends EType {
    public int eType() {
        return 16;
    }

    public int minimumPadSize() {
        return 0;
    }

    public int confounderSize() {
        return this.blockSize();
    }

    public int checksumType() {
        return 12;
    }

    public int checksumSize() {
        return Des3.getChecksumLength();
    }

    public int blockSize() {
        return 8;
    }

    public int keyType() {
        return 2;
    }

    public int keySize() {
        return 24;
    }

    public byte[] encrypt(byte[] data, byte[] key, int usage) throws KrbCryptoException {
        byte[] ivec = new byte[this.blockSize()];
        return this.encrypt(data, key, ivec, usage);
    }

    public byte[] encrypt(byte[] data, byte[] key, byte[] ivec, int usage) throws KrbCryptoException {
        try {
            return Des3.encrypt(key, usage, ivec, data, 0, data.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws KrbApErrException, KrbCryptoException {
        byte[] ivec = new byte[this.blockSize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws KrbApErrException, KrbCryptoException {
        try {
            return Des3.decrypt(key, usage, ivec, cipher, 0, cipher.length);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public byte[] decryptedData(byte[] data) {
        return data;
    }
}

