/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.CksumType;
import sun.security.krb5.internal.crypto.Des3;

public class HmacSha1Des3KdCksumType
extends CksumType {
    public int confounderSize() {
        return 8;
    }

    public int cksumType() {
        return 12;
    }

    public boolean isSafe() {
        return true;
    }

    public int cksumSize() {
        return 20;
    }

    public int keyType() {
        return 2;
    }

    public int keySize() {
        return 24;
    }

    public byte[] calculateChecksum(byte[] data, int size) {
        return null;
    }

    public byte[] calculateKeyedChecksum(byte[] data, int size, byte[] key, int usage) throws KrbCryptoException {
        try {
            return Des3.calculateChecksum(key, usage, data, 0, size);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }

    public boolean verifyKeyedChecksum(byte[] data, int size, byte[] key, byte[] checksum, int usage) throws KrbCryptoException {
        try {
            byte[] newCksum = Des3.calculateChecksum(key, usage, data, 0, size);
            return HmacSha1Des3KdCksumType.isChecksumEqual(checksum, newCksum);
        }
        catch (GeneralSecurityException e) {
            KrbCryptoException ke = new KrbCryptoException(e.getMessage());
            ke.initCause(e);
            throw ke;
        }
    }
}

