/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.Certificate;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.KeyException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Signer;

public class SystemSigner
extends Signer {
    private static final long serialVersionUID = -2127743304301557711L;
    private boolean trusted = false;

    public SystemSigner(String name) {
        super(name);
    }

    public SystemSigner(String name, IdentityScope scope) throws KeyManagementException {
        super(name, scope);
    }

    void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    void setSignerKeyPair(KeyPair pair) throws InvalidParameterException, KeyException {
        this.setKeyPair(pair);
    }

    PrivateKey getSignerPrivateKey() {
        return this.getPrivateKey();
    }

    void setSignerInfo(String s) {
        this.setInfo(s);
    }

    void addSignerCertificate(Certificate cert) throws KeyManagementException {
        this.addCertificate(cert);
    }

    void clearCertificates() throws KeyManagementException {
        Certificate[] certs = this.certificates();
        for (int i = 0; i < certs.length; ++i) {
            this.removeCertificate(certs[i]);
        }
    }

    public String toString() {
        String trustedString = "not trusted";
        if (this.trusted) {
            trustedString = "trusted";
        }
        return super.toString() + "[" + trustedString + "]";
    }
}

