/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import sun.misc.BASE64Decoder;
import sun.security.pkcs.PKCS7;
import sun.security.provider.certpath.X509CertPath;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Cache;
import sun.security.util.DerValue;
import sun.security.x509.X509CRLImpl;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509Factory
extends CertificateFactorySpi {
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    private static final int defaultExpectedLineLength = 80;
    private static final char[] endBoundary = "-----END".toCharArray();
    private static final int ENC_MAX_LENGTH = 0x400000;
    private static final Cache certCache = Cache.newSoftMemoryCache(750);
    private static final Cache crlCache = Cache.newSoftMemoryCache(750);

    @Override
    public Certificate engineGenerateCertificate(InputStream is) throws CertificateException {
        if (is == null) {
            certCache.clear();
            X509CertificatePair.clearCache();
            throw new CertificateException("Missing input stream");
        }
        try {
            X509CertImpl cert;
            byte[] encoding;
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if ((encoding = X509Factory.readSequence(is)) != null) {
                X509CertImpl cert2 = (X509CertImpl)X509Factory.getFromCache(certCache, encoding);
                if (cert2 != null) {
                    return cert2;
                }
                cert2 = new X509CertImpl(encoding);
                X509Factory.addToCache(certCache, cert2.getEncodedInternal(), cert2);
                return cert2;
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                cert = new X509CertImpl(data);
            } else {
                cert = new X509CertImpl(new DerValue(is));
            }
            return X509Factory.intern(cert);
        }
        catch (IOException ioe) {
            throw (CertificateException)new CertificateException("Could not parse certificate: " + ioe.toString()).initCause(ioe);
        }
    }

    private static byte[] readSequence(InputStream in) throws IOException {
        int totalLength;
        int valueLength;
        in.mark(0x400000);
        byte[] b = new byte[4];
        int i = X509Factory.readFully(in, b, 0, b.length);
        if (i != b.length || b[0] != 48) {
            in.reset();
            return null;
        }
        i = b[1] & 0xFF;
        if (i < 128) {
            valueLength = i;
            totalLength = valueLength + 2;
        } else if (i == 129) {
            valueLength = b[2] & 0xFF;
            totalLength = valueLength + 3;
        } else if (i == 130) {
            valueLength = (b[2] & 0xFF) << 8 | b[3] & 0xFF;
            totalLength = valueLength + 4;
        } else {
            in.reset();
            return null;
        }
        if (totalLength > 0x400000) {
            in.reset();
            return null;
        }
        byte[] encoding = new byte[totalLength];
        if (totalLength < b.length) {
            in.reset();
            i = X509Factory.readFully(in, encoding, 0, totalLength);
            if (i != totalLength) {
                in.reset();
                return null;
            }
        } else {
            System.arraycopy(b, 0, encoding, 0, b.length);
            int n = totalLength - b.length;
            i = X509Factory.readFully(in, encoding, b.length, n);
            if (i != n) {
                in.reset();
                return null;
            }
        }
        return encoding;
    }

    private static int readFully(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int n;
        int read = 0;
        while (length > 0 && (n = in.read(buffer, offset, length)) > 0) {
            read += n;
            length -= n;
            offset += n;
        }
        return read;
    }

    public static synchronized X509CertImpl intern(X509Certificate c) throws CertificateException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CertImpl;
        byte[] encoding = isImpl ? ((X509CertImpl)c).getEncodedInternal() : c.getEncoded();
        X509CertImpl newC = (X509CertImpl)X509Factory.getFromCache(certCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CertImpl)c;
        } else {
            newC = new X509CertImpl(encoding);
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(certCache, encoding, newC);
        return newC;
    }

    public static synchronized X509CRLImpl intern(X509CRL c) throws CRLException {
        if (c == null) {
            return null;
        }
        boolean isImpl = c instanceof X509CRLImpl;
        byte[] encoding = isImpl ? ((X509CRLImpl)c).getEncodedInternal() : c.getEncoded();
        X509CRLImpl newC = (X509CRLImpl)X509Factory.getFromCache(crlCache, encoding);
        if (newC != null) {
            return newC;
        }
        if (isImpl) {
            newC = (X509CRLImpl)c;
        } else {
            newC = new X509CRLImpl(encoding);
            encoding = newC.getEncodedInternal();
        }
        X509Factory.addToCache(crlCache, encoding, newC);
        return newC;
    }

    private static synchronized Object getFromCache(Cache cache, byte[] encoding) {
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        Object value = cache.get(key);
        return value;
    }

    private static synchronized void addToCache(Cache cache, byte[] encoding, Object value) {
        if (encoding.length > 0x400000) {
            return;
        }
        Cache.EqualByteArray key = new Cache.EqualByteArray(encoding);
        cache.put(key, value);
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!inStream.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(inStream));
                inStream = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(inStream)) {
                byte[] data = this.base64_to_binary(inStream);
                return new X509CertPath(new ByteArrayInputStream(data));
            }
            return new X509CertPath(inStream);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.getMessage());
        }
    }

    @Override
    public CertPath engineGenerateCertPath(InputStream inStream, String encoding) throws CertificateException {
        if (inStream == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!inStream.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(inStream));
                inStream = new ByteArrayInputStream(totalBytes);
            }
            if (this.isBase64(inStream)) {
                byte[] data = this.base64_to_binary(inStream);
                return new X509CertPath(new ByteArrayInputStream(data), encoding);
            }
            return new X509CertPath(inStream, encoding);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe.getMessage());
        }
    }

    @Override
    public CertPath engineGenerateCertPath(List<? extends Certificate> certificates) throws CertificateException {
        return new X509CertPath(certificates);
    }

    @Override
    public Iterator<String> engineGetCertPathEncodings() {
        return X509CertPath.getEncodingsStatic();
    }

    @Override
    public Collection<? extends Certificate> engineGenerateCertificates(InputStream is) throws CertificateException {
        if (is == null) {
            throw new CertificateException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                is = new ByteArrayInputStream(this.getTotalBytes(new BufferedInputStream(is)));
            }
            return this.parseX509orPKCS7Cert(is);
        }
        catch (IOException ioe) {
            throw new CertificateException(ioe);
        }
    }

    @Override
    public CRL engineGenerateCRL(InputStream is) throws CRLException {
        if (is == null) {
            crlCache.clear();
            throw new CRLException("Missing input stream");
        }
        try {
            X509CRLImpl crl;
            byte[] encoding;
            if (!is.markSupported()) {
                byte[] totalBytes = this.getTotalBytes(new BufferedInputStream(is));
                is = new ByteArrayInputStream(totalBytes);
            }
            if ((encoding = X509Factory.readSequence(is)) != null) {
                X509CRLImpl crl2 = (X509CRLImpl)X509Factory.getFromCache(crlCache, encoding);
                if (crl2 != null) {
                    return crl2;
                }
                crl2 = new X509CRLImpl(encoding);
                X509Factory.addToCache(crlCache, crl2.getEncodedInternal(), crl2);
                return crl2;
            }
            if (this.isBase64(is)) {
                byte[] data = this.base64_to_binary(is);
                crl = new X509CRLImpl(data);
            } else {
                crl = new X509CRLImpl(new DerValue(is));
            }
            return X509Factory.intern(crl);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.getMessage());
        }
    }

    @Override
    public Collection<? extends CRL> engineGenerateCRLs(InputStream is) throws CRLException {
        if (is == null) {
            throw new CRLException("Missing input stream");
        }
        try {
            if (!is.markSupported()) {
                is = new ByteArrayInputStream(this.getTotalBytes(new BufferedInputStream(is)));
            }
            return this.parseX509orPKCS7CRL(is);
        }
        catch (IOException ioe) {
            throw new CRLException(ioe.getMessage());
        }
    }

    private Collection<? extends Certificate> parseX509orPKCS7Cert(InputStream is) throws CertificateException, IOException {
        ArrayList<X509CertImpl> coll = new ArrayList<X509CertImpl>();
        boolean first = true;
        while (is.available() != 0) {
            InputStream is2 = is;
            if (this.isBase64(is2)) {
                is2 = new ByteArrayInputStream(this.base64_to_binary(is2));
            }
            if (first) {
                is2.mark(is2.available());
            }
            try {
                coll.add(X509Factory.intern(new X509CertImpl(new DerValue(is2))));
            }
            catch (CertificateException e) {
                Throwable cause = e.getCause();
                if (first && cause != null && cause instanceof IOException) {
                    is2.reset();
                    PKCS7 pkcs7 = new PKCS7(is2);
                    X509Certificate[] certs = pkcs7.getCertificates();
                    if (certs != null) {
                        return Arrays.asList(certs);
                    }
                    return new ArrayList(0);
                }
                throw e;
            }
            first = false;
        }
        return coll;
    }

    private Collection<? extends CRL> parseX509orPKCS7CRL(InputStream is) throws CRLException, IOException {
        ArrayList<X509CRLImpl> coll = new ArrayList<X509CRLImpl>();
        boolean first = true;
        while (is.available() != 0) {
            block6: {
                InputStream is2 = is;
                if (this.isBase64(is)) {
                    is2 = new ByteArrayInputStream(this.base64_to_binary(is2));
                }
                if (first) {
                    is2.mark(is2.available());
                }
                try {
                    coll.add(new X509CRLImpl(is2));
                }
                catch (CRLException e) {
                    if (!first) break block6;
                    is2.reset();
                    PKCS7 pkcs7 = new PKCS7(is2);
                    X509CRL[] crls = pkcs7.getCRLs();
                    if (crls != null) {
                        return Arrays.asList(crls);
                    }
                    return new ArrayList(0);
                }
            }
            first = false;
        }
        return coll;
    }

    private byte[] base64_to_binary(InputStream is) throws IOException {
        long len = 0L;
        is.mark(is.available());
        BufferedInputStream bufin = new BufferedInputStream(is);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)bufin, "ASCII"));
        String temp = this.readLine(br);
        if (temp == null || !temp.startsWith("-----BEGIN")) {
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        StringBuffer strBuf = new StringBuffer();
        while ((temp = this.readLine(br)) != null && !temp.startsWith("-----END")) {
            strBuf.append(temp);
        }
        if (temp == null) {
            throw new IOException("Unsupported encoding");
        }
        len += (long)temp.length();
        is.reset();
        is.skip(len += (long)strBuf.length());
        BASE64Decoder decoder = new BASE64Decoder();
        return decoder.decodeBuffer(strBuf.toString());
    }

    private byte[] getTotalBytes(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        baos.reset();
        while ((n = is.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, n);
        }
        return baos.toByteArray();
    }

    private boolean isBase64(InputStream is) throws IOException {
        if (is.available() >= 10) {
            is.mark(10);
            int c1 = is.read();
            int c2 = is.read();
            int c3 = is.read();
            int c4 = is.read();
            int c5 = is.read();
            int c6 = is.read();
            int c7 = is.read();
            int c8 = is.read();
            int c9 = is.read();
            int c10 = is.read();
            is.reset();
            return c1 == 45 && c2 == 45 && c3 == 45 && c4 == 45 && c5 == 45 && c6 == 66 && c7 == 69 && c8 == 71 && c9 == 73 && c10 == 78;
        }
        return false;
    }

    private String readLine(BufferedReader br) throws IOException {
        int c;
        int i = 0;
        boolean isMatch = true;
        boolean matched = false;
        StringBuffer sb = new StringBuffer(80);
        do {
            c = br.read();
            if (isMatch && i < endBoundary.length) {
                boolean bl = isMatch = (char)c == endBoundary[i++];
            }
            if (!matched) {
                matched = isMatch && i == endBoundary.length;
            }
            sb.append((char)c);
        } while (c != -1 && c != 10 && c != 13);
        if (!matched && c == -1) {
            return null;
        }
        if (c == 13) {
            br.mark(1);
            int c2 = br.read();
            if (c2 == 10) {
                sb.append((char)c);
            } else {
                br.reset();
            }
        }
        return sb.toString();
    }
}

