/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.CertificateRevokedException;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCSPChecker
extends PKIXCertPathChecker {
    static final String OCSP_ENABLE_PROP = "ocsp.enable";
    static final String OCSP_URL_PROP = "ocsp.responderURL";
    static final String OCSP_CERT_SUBJECT_PROP = "ocsp.responderCertSubjectName";
    static final String OCSP_CERT_ISSUER_PROP = "ocsp.responderCertIssuerName";
    static final String OCSP_CERT_NUMBER_PROP = "ocsp.responderCertSerialNumber";
    private static final String HEX_DIGITS = "0123456789ABCDEFabcdef";
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private int remainingCerts;
    private X509Certificate[] certs;
    private CertPath cp;
    private PKIXParameters pkixParams;
    private boolean onlyEECert = false;

    OCSPChecker(CertPath certPath, PKIXParameters pkixParams) throws CertPathValidatorException {
        this(certPath, pkixParams, false);
    }

    OCSPChecker(CertPath certPath, PKIXParameters pkixParams, boolean onlyEECert) throws CertPathValidatorException {
        this.cp = certPath;
        this.pkixParams = pkixParams;
        this.onlyEECert = onlyEECert;
        List<? extends Certificate> tmp = this.cp.getCertificates();
        this.certs = tmp.toArray(new X509Certificate[tmp.size()]);
        this.init(false);
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certs.length;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return Collections.emptySet();
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        X509CertImpl currCertImpl = null;
        try {
            currCertImpl = X509CertImpl.toImpl((X509Certificate)cert);
        }
        catch (CertificateException ce) {
            throw new CertPathValidatorException(ce);
        }
        if (this.onlyEECert && currCertImpl.getBasicConstraints() != -1) {
            if (DEBUG != null) {
                DEBUG.println("Skipping revocation check, not end entity cert");
            }
            return;
        }
        String[] properties = OCSPChecker.getOCSPProperties();
        URI uri = OCSPChecker.getOCSPServerURI(currCertImpl, properties[0]);
        X500Principal responderSubjectName = null;
        X500Principal responderIssuerName = null;
        BigInteger responderSerialNumber = null;
        if (properties[1] != null) {
            responderSubjectName = new X500Principal(properties[1]);
        } else if (properties[2] != null && properties[3] != null) {
            responderIssuerName = new X500Principal(properties[2]);
            String value = OCSPChecker.stripOutSeparators(properties[3]);
            responderSerialNumber = new BigInteger(value, 16);
        } else if (properties[2] != null || properties[3] != null) {
            throw new CertPathValidatorException("Must specify both ocsp.responderCertIssuerName and ocsp.responderCertSerialNumber properties");
        }
        boolean seekResponderCert = false;
        if (responderSubjectName != null || responderIssuerName != null) {
            seekResponderCert = true;
        }
        X509Certificate issuerCert = null;
        boolean seekIssuerCert = true;
        X509Certificate responderCert = null;
        if (this.remainingCerts < this.certs.length) {
            issuerCert = this.certs[this.remainingCerts];
            seekIssuerCert = false;
            if (!seekResponderCert) {
                responderCert = issuerCert;
                if (DEBUG != null) {
                    DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                }
            }
        }
        if (seekIssuerCert || seekResponderCert) {
            Iterator<TrustAnchor> anchors;
            if (DEBUG != null && seekResponderCert) {
                DEBUG.println("Searching trust anchors for responder's certificate");
            }
            if (!(anchors = this.pkixParams.getTrustAnchors().iterator()).hasNext()) {
                throw new CertPathValidatorException("Must specify at least one trust anchor");
            }
            X500Principal certIssuerName = currCertImpl.getIssuerX500Principal();
            while (anchors.hasNext() && (seekIssuerCert || seekResponderCert)) {
                TrustAnchor anchor = anchors.next();
                X509Certificate anchorCert = anchor.getTrustedCert();
                X500Principal anchorSubjectName = anchorCert.getSubjectX500Principal();
                if (seekIssuerCert && certIssuerName.equals(anchorSubjectName)) {
                    issuerCert = anchorCert;
                    seekIssuerCert = false;
                    if (!seekResponderCert && responderCert == null) {
                        responderCert = anchorCert;
                        if (DEBUG != null) {
                            DEBUG.println("Responder's certificate is the same as the issuer of the certificate being validated");
                        }
                    }
                }
                if (!seekResponderCert || (responderSubjectName == null || !responderSubjectName.equals(anchorSubjectName)) && (responderIssuerName == null || responderSerialNumber == null || !responderIssuerName.equals(anchorCert.getIssuerX500Principal()) || !responderSerialNumber.equals(anchorCert.getSerialNumber()))) continue;
                responderCert = anchorCert;
                seekResponderCert = false;
            }
            if (issuerCert == null) {
                throw new CertPathValidatorException("No trusted certificate for " + currCertImpl.getIssuerDN());
            }
            if (seekResponderCert) {
                if (DEBUG != null) {
                    DEBUG.println("Searching cert stores for responder's certificate");
                }
                X509CertSelector filter = null;
                if (responderSubjectName != null) {
                    filter = new X509CertSelector();
                    filter.setSubject(responderSubjectName);
                } else if (responderIssuerName != null && responderSerialNumber != null) {
                    filter = new X509CertSelector();
                    filter.setIssuer(responderIssuerName);
                    filter.setSerialNumber(responderSerialNumber);
                }
                if (filter != null) {
                    List<CertStore> certStores = this.pkixParams.getCertStores();
                    AlgorithmChecker algChecker = AlgorithmChecker.getInstance();
                    for (CertStore certStore : certStores) {
                        try {
                            for (Certificate certificate : certStore.getCertificates(filter)) {
                                try {
                                    AlgorithmChecker.check(certificate);
                                    responderCert = (X509Certificate)certificate;
                                    seekResponderCert = false;
                                    break;
                                }
                                catch (CertPathValidatorException cpve) {
                                    if (DEBUG == null) continue;
                                    DEBUG.println("OCSP responder certificate algorithm check failed: " + cpve);
                                }
                            }
                            if (seekResponderCert) continue;
                            break;
                        }
                        catch (CertStoreException cse) {
                            if (DEBUG == null) continue;
                            DEBUG.println("CertStore exception:" + cse);
                        }
                    }
                }
            }
            if (seekResponderCert) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
            CertId certId = null;
            OCSPResponse response = null;
            try {
                certId = new CertId(issuerCert, currCertImpl.getSerialNumberObject());
                response = OCSP.check(Collections.singletonList(certId), uri, responderCert, this.pkixParams.getDate());
            }
            catch (Exception e) {
                if (e instanceof CertPathValidatorException) {
                    throw (CertPathValidatorException)e;
                }
                throw new CertPathValidatorException(e);
            }
            OCSPResponse.SingleResponse rs = response.getSingleResponse(certId);
            OCSP.RevocationStatus.CertStatus certStatus = rs.getCertStatus();
            if (certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                throw new CertificateRevokedException(this.cp, this.remainingCerts - 1);
            }
            if (certStatus == OCSP.RevocationStatus.CertStatus.UNKNOWN) {
                throw new CertPathValidatorException("Certificate's revocation status is unknown", null, this.cp, this.remainingCerts - 1);
            }
        }
    }

    private static URI getOCSPServerURI(X509CertImpl currCertImpl, String responderURL) throws CertPathValidatorException {
        if (responderURL != null) {
            try {
                return new URI(responderURL);
            }
            catch (URISyntaxException e) {
                throw new CertPathValidatorException(e);
            }
        }
        AuthorityInfoAccessExtension aia = currCertImpl.getAuthorityInfoAccessExtension();
        if (aia == null) {
            throw new CertPathValidatorException("Must specify the location of an OCSP Responder");
        }
        List<AccessDescription> descriptions = aia.getAccessDescriptions();
        for (AccessDescription description : descriptions) {
            GeneralName generalName;
            if (!description.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (generalName = description.getAccessLocation()).getType() != 6) continue;
            URIName uri = (URIName)generalName.getName();
            return uri.getURI();
        }
        throw new CertPathValidatorException("Cannot find the location of the OCSP Responder");
    }

    private static String[] getOCSPProperties() {
        final String[] properties = new String[4];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                properties[0] = Security.getProperty(OCSPChecker.OCSP_URL_PROP);
                properties[1] = Security.getProperty(OCSPChecker.OCSP_CERT_SUBJECT_PROP);
                properties[2] = Security.getProperty(OCSPChecker.OCSP_CERT_ISSUER_PROP);
                properties[3] = Security.getProperty(OCSPChecker.OCSP_CERT_NUMBER_PROP);
                return null;
            }
        });
        return properties;
    }

    private static String stripOutSeparators(String value) {
        char[] chars = value.toCharArray();
        StringBuilder hexNumber = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (HEX_DIGITS.indexOf(chars[i]) == -1) continue;
            hexNumber.append(chars[i]);
        }
        return hexNumber.toString();
    }
}

