/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class AccessibleMethod {
    private final Method method;

    public AccessibleMethod(Class klass, String methodName, Class ... paramTypes) throws NoSuchMethodException {
        try {
            this.method = AccessController.doPrivileged(new AccessMethodAction(klass, methodName, paramTypes));
        }
        catch (PrivilegedActionException e) {
            throw (NoSuchMethodException)e.getCause();
        }
    }

    public Object invoke(Object obj, Object ... args) throws IllegalArgumentException, InvocationTargetException {
        try {
            return this.method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)"accessible method inaccessible");
        }
    }

    public Object invokeNoChecked(Object obj, Object ... args) {
        try {
            return this.invoke(obj, args);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getCause());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AccessMethodAction
    implements PrivilegedExceptionAction<Method> {
        private final Class klass;
        private final String methodName;
        private final Class[] paramTypes;

        public AccessMethodAction(Class klass, String methodName, Class ... paramTypes) {
            this.klass = klass;
            this.methodName = methodName;
            this.paramTypes = paramTypes;
        }

        @Override
        public Method run() throws NoSuchMethodException {
            Method method = this.klass.getDeclaredMethod(this.methodName, this.paramTypes);
            method.setAccessible(true);
            return method;
        }
    }
}

