/*
 * Decompiled with CFR 0.152.
 */
package sun.text.normalizer;

import sun.text.normalizer.UCharacterProperty;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.VersionInfo;

public final class UCharacter {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final double NO_NUMERIC_VALUE = -1.23456789E8;
    private static final UCharacterProperty PROPERTY_;
    private static final char[] PROPERTY_TRIE_INDEX_;
    private static final char[] PROPERTY_TRIE_DATA_;
    private static final int[] PROPERTY_DATA_;
    private static final int PROPERTY_INITIAL_VALUE_;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int SHIFT_24_ = 24;
    private static final int NUMERIC_TYPE_SHIFT_ = 12;
    private static final int NUMERIC_TYPE_MASK_ = 28672;
    private static final int BIDI_SHIFT_ = 6;
    private static final int BIDI_MASK_AFTER_SHIFT_ = 31;
    private static final int NUMERATOR_POWER_LIMIT_ = 0x7FFFFF00;
    private static final int JOINING_TYPE_MASK_ = 14336;
    private static final int JOINING_TYPE_SHIFT_ = 11;
    private static final int JOINING_GROUP_MASK_ = 2016;
    private static final int JOINING_GROUP_SHIFT_ = 5;
    private static final int DECOMPOSITION_TYPE_MASK_ = 31;
    private static final int EAST_ASIAN_MASK_ = 229376;
    private static final int EAST_ASIAN_SHIFT_ = 15;
    private static final int LINE_BREAK_MASK_ = 0x7C0000;
    private static final int LINE_BREAK_SHIFT_ = 18;
    private static final int BLOCK_MASK_ = 32640;
    private static final int BLOCK_SHIFT_ = 7;
    private static final int SCRIPT_MASK_ = 127;

    public static int digit(int ch, int radix) {
        int result;
        int props = UCharacter.getProperty(ch);
        if (UCharacter.getNumericType(props) != 1) {
            return radix <= 10 ? -1 : UCharacter.getEuropeanDigit(ch);
        }
        if (UCharacter.isNotExceptionIndicator(props)) {
            if (props >= 0) {
                return UCharacterProperty.getSignedValue(props);
            }
        } else {
            int result2;
            int index = UCharacterProperty.getExceptionIndex(props);
            if (PROPERTY_.hasExceptionValue(index, 4) && (result2 = PROPERTY_.getException(index, 4)) >= 0) {
                return result2;
            }
        }
        if (radix > 10 && (result = UCharacter.getEuropeanDigit(ch)) >= 0 && result < radix) {
            return result;
        }
        return -1;
    }

    public static double getUnicodeNumericValue(int ch) {
        int props = PROPERTY_.getProperty(ch);
        int numericType = UCharacter.getNumericType(props);
        if (numericType > 0 && numericType < 4) {
            if (UCharacter.isNotExceptionIndicator(props)) {
                return UCharacterProperty.getSignedValue(props);
            }
            int index = UCharacterProperty.getExceptionIndex(props);
            boolean nex = false;
            boolean dex = false;
            double numerator = 0.0;
            if (PROPERTY_.hasExceptionValue(index, 4)) {
                int num = PROPERTY_.getException(index, 4);
                numerator = num >= 0x7FFFFF00 ? Math.pow(10.0, num &= 0xFF) : (double)num;
                nex = true;
            }
            double denominator = 0.0;
            if (PROPERTY_.hasExceptionValue(index, 5)) {
                denominator = PROPERTY_.getException(index, 5);
                if (numerator != 0.0) {
                    return numerator / denominator;
                }
                dex = true;
            }
            if (nex) {
                if (dex) {
                    return numerator / denominator;
                }
                return numerator;
            }
            if (dex) {
                return 1.0 / denominator;
            }
        }
        return -1.23456789E8;
    }

    public static int getType(int ch) {
        return UCharacter.getProperty(ch) & 0x1F;
    }

    public static int getCodePoint(char lead, char trail) {
        if (lead >= '\ud800' && lead <= '\udbff' && trail >= '\udc00' && trail <= '\udfff') {
            return UCharacterProperty.getRawSupplementary(lead, trail);
        }
        throw new IllegalArgumentException("Illegal surrogate characters");
    }

    public static int getDirection(int ch) {
        return UCharacter.getProperty(ch) >> 6 & 0x1F;
    }

    public static String foldCase(String str, boolean defaultmapping) {
        int size = str.length();
        StringBuffer result = new StringBuffer(size);
        int offset = 0;
        while (offset < size) {
            int ch = UTF16.charAt(str, offset);
            offset += UTF16.getCharCount(ch);
            int props = PROPERTY_.getProperty(ch);
            if (UCharacter.isNotExceptionIndicator(props)) {
                int type = 0x1F & props;
                if (type == 1 || type == 3) {
                    ch += UCharacterProperty.getSignedValue(props);
                }
            } else {
                int index = UCharacterProperty.getExceptionIndex(props);
                if (PROPERTY_.hasExceptionValue(index, 8)) {
                    int exception = PROPERTY_.getException(index, 8);
                    if (exception != 0) {
                        PROPERTY_.getFoldCase(exception & 0xFFFF, exception >> 24, result);
                        continue;
                    }
                    if (ch != 73 && ch != 304) {
                        UTF16.append(result, ch);
                        continue;
                    }
                    if (defaultmapping) {
                        if (ch == 73) {
                            result.append('i');
                            continue;
                        }
                        if (ch != 304) continue;
                        result.append('i');
                        result.append('\u0307');
                        continue;
                    }
                    if (ch == 73) {
                        result.append('\u0131');
                        continue;
                    }
                    if (ch != 304) continue;
                    result.append('i');
                    continue;
                }
                if (PROPERTY_.hasExceptionValue(index, 1)) {
                    ch = PROPERTY_.getException(index, 1);
                }
            }
            UTF16.append(result, ch);
        }
        return result.toString();
    }

    public static VersionInfo getAge(int ch) {
        if (ch < 0 || ch > 0x10FFFF) {
            throw new IllegalArgumentException("Codepoint out of bounds");
        }
        return PROPERTY_.getAge(ch);
    }

    public static int getIntPropertyValue(int ch, int type) {
        if (type == 4107 && ch >= 4352) {
            if (ch <= 4607) {
                if (ch <= 4447) {
                    if (ch == 4447 || ch <= 4441 || UCharacter.getType(ch) == 5) {
                        return 1;
                    }
                } else if (ch <= 4519) {
                    if (ch <= 4514 || UCharacter.getType(ch) == 5) {
                        return 2;
                    }
                } else if (ch <= 4601 || UCharacter.getType(ch) == 5) {
                    return 3;
                }
            } else if ((ch -= 44032) >= 0 && ch < 11172) {
                return ch % 28 == 0 ? 4 : 5;
            }
        }
        return 0;
    }

    private UCharacter() {
    }

    private static int getEuropeanDigit(int ch) {
        if (ch > 122 && ch < 65313 || ch < 65 || ch > 90 && ch < 97 || ch > 65370 || ch > 65329 && ch < 65345) {
            return -1;
        }
        if (ch <= 122) {
            return ch + 10 - (ch <= 90 ? 65 : 97);
        }
        if (ch <= 65338) {
            return ch + 10 - 65313;
        }
        return ch + 10 - 65345;
    }

    private static int getNumericType(int props) {
        return (props & 0x7000) >> 12;
    }

    private static boolean isNotExceptionIndicator(int props) {
        return (props & 0x20) == 0;
    }

    private static int getProperty(int ch) {
        if (ch < 55296 || ch > 56319 && ch < 65536) {
            try {
                return PROPERTY_DATA_[PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[ch >> 5] << 2) + (ch & 0x1F)]];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return PROPERTY_INITIAL_VALUE_;
            }
        }
        if (ch <= 56319) {
            return PROPERTY_DATA_[PROPERTY_TRIE_DATA_[(PROPERTY_TRIE_INDEX_[320 + (ch >> 5)] << 2) + (ch & 0x1F)]];
        }
        if (ch <= 0x10FFFF) {
            return PROPERTY_DATA_[UCharacter.PROPERTY_.m_trie_.getSurrogateValue(UTF16.getLeadSurrogate(ch), (char)(ch & 0x3FF))];
        }
        return PROPERTY_INITIAL_VALUE_;
    }

    static {
        try {
            PROPERTY_ = UCharacterProperty.getInstance();
            PROPERTY_TRIE_INDEX_ = UCharacter.PROPERTY_.m_trieIndex_;
            PROPERTY_TRIE_DATA_ = UCharacter.PROPERTY_.m_trieData_;
            PROPERTY_DATA_ = UCharacter.PROPERTY_.m_property_;
            PROPERTY_INITIAL_VALUE_ = PROPERTY_DATA_[UCharacter.PROPERTY_.m_trieInitialValue_];
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static interface ECharacterCategory {
        public static final int UPPERCASE_LETTER = 1;
        public static final int TITLECASE_LETTER = 3;
        public static final int OTHER_LETTER = 5;
    }

    public static interface HangulSyllableType {
        public static final int NOT_APPLICABLE = 0;
        public static final int LEADING_JAMO = 1;
        public static final int VOWEL_JAMO = 2;
        public static final int TRAILING_JAMO = 3;
        public static final int LV_SYLLABLE = 4;
        public static final int LVT_SYLLABLE = 5;
        public static final int COUNT = 6;
    }

    public static interface NumericType {
        public static final int NONE = 0;
        public static final int DECIMAL = 1;
        public static final int DIGIT = 2;
        public static final int NUMERIC = 3;
        public static final int COUNT = 4;
    }
}

