/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XMBeanNotifications;
import sun.tools.jconsole.inspector.XMBeanOperations;
import sun.tools.jconsole.inspector.XNodeInfo;
import sun.tools.jconsole.inspector.XTree;

public class XSheet
extends JPanel
implements ActionListener,
NotificationListener {
    private JPanel mainPanel;
    private JPanel southPanel;
    private DefaultMutableTreeNode node;
    private XMBean mbean;
    private XMBeanAttributes mbeanAttributes;
    private XMBeanOperations mbeanOperations;
    private XMBeanNotifications mbeanNotifications;
    private XMBeanInfo mbeanInfo;
    private JButton refreshButton;
    private JButton clearButton;
    private JButton subscribeButton;
    private JButton unsubscribeButton;
    private MBeansTab mbeansTab;

    public XSheet(MBeansTab mbeansTab) {
        this.mbeansTab = mbeansTab;
        this.setupScreen();
    }

    public void dispose() {
        this.clear();
        XDataViewer.dispose(this.mbeansTab);
        this.mbeanNotifications.dispose();
    }

    private void setupScreen() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.southPanel = new JPanel();
        this.add((Component)this.southPanel, "South");
        String refreshButtonKey = "MBeansTab.refreshAttributesButton";
        this.refreshButton = new JButton(Resources.getText(refreshButtonKey, new Object[0]));
        this.refreshButton.setMnemonic(Resources.getMnemonicInt(refreshButtonKey));
        this.refreshButton.setToolTipText(Resources.getText(refreshButtonKey + ".toolTip", new Object[0]));
        this.refreshButton.addActionListener(this);
        String clearButtonKey = "MBeansTab.clearNotificationsButton";
        this.clearButton = new JButton(Resources.getText(clearButtonKey, new Object[0]));
        this.clearButton.setMnemonic(Resources.getMnemonicInt(clearButtonKey));
        this.clearButton.setToolTipText(Resources.getText(clearButtonKey + ".toolTip", new Object[0]));
        this.clearButton.addActionListener(this);
        String subscribeButtonKey = "MBeansTab.subscribeNotificationsButton";
        this.subscribeButton = new JButton(Resources.getText(subscribeButtonKey, new Object[0]));
        this.subscribeButton.setMnemonic(Resources.getMnemonicInt(subscribeButtonKey));
        this.subscribeButton.setToolTipText(Resources.getText(subscribeButtonKey + ".toolTip", new Object[0]));
        this.subscribeButton.addActionListener(this);
        String unsubscribeButtonKey = "MBeansTab.unsubscribeNotificationsButton";
        this.unsubscribeButton = new JButton(Resources.getText(unsubscribeButtonKey, new Object[0]));
        this.unsubscribeButton.setMnemonic(Resources.getMnemonicInt(unsubscribeButtonKey));
        this.unsubscribeButton.setToolTipText(Resources.getText(unsubscribeButtonKey + ".toolTip", new Object[0]));
        this.unsubscribeButton.addActionListener(this);
        this.mbeanAttributes = new XMBeanAttributes(this.mbeansTab);
        this.mbeanOperations = new XMBeanOperations(this.mbeansTab);
        this.mbeanOperations.addOperationsListener(this);
        this.mbeanNotifications = new XMBeanNotifications();
        this.mbeanNotifications.addNotificationsListener(this);
        this.mbeanInfo = new XMBeanInfo();
    }

    public boolean isMBeanNode(DefaultMutableTreeNode node) {
        XNodeInfo uo = (XNodeInfo)node.getUserObject();
        return uo.getType().equals((Object)XNodeInfo.Type.MBEAN);
    }

    public void displayNode(DefaultMutableTreeNode node) {
        this.clear();
        if (node == null) {
            this.displayEmptyNode();
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof XNodeInfo) {
            XNodeInfo uo = (XNodeInfo)userObject;
            switch (uo.getType()) {
                case MBEAN: {
                    this.displayMBeanNode(node);
                    break;
                }
                case NONMBEAN: {
                    this.displayEmptyNode();
                    break;
                }
                case ATTRIBUTES: {
                    this.displayMBeanAttributesNode(node);
                    break;
                }
                case OPERATIONS: {
                    this.displayMBeanOperationsNode(node);
                    break;
                }
                case NOTIFICATIONS: {
                    this.displayMBeanNotificationsNode(node);
                    break;
                }
                case ATTRIBUTE: 
                case OPERATION: 
                case NOTIFICATION: {
                    this.displayMetadataNode(node);
                    break;
                }
                default: {
                    this.displayEmptyNode();
                    break;
                }
            }
        } else {
            this.displayEmptyNode();
        }
    }

    private void displayMBeanNode(final DefaultMutableTreeNode node) {
        final XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            return;
        }
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = node;
                    XSheet.this.mbean = (XMBean)uo.getData();
                    XSheet.this.mbeanInfo.addMBeanInfo(XSheet.this.mbean, XSheet.this.mbean.getMBeanInfo());
                }
                catch (Throwable ex) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, ex.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        XSheet.this.mainPanel.add((Component)XSheet.this.mbeanInfo, "Center");
                        XSheet.this.southPanel.setVisible(false);
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayMetadataNode(DefaultMutableTreeNode node) {
        final XNodeInfo uo = (XNodeInfo)node.getUserObject();
        final XMBeanInfo mbi = this.mbeanInfo;
        switch (uo.getType()) {
            case ATTRIBUTE: {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        Object attrData = uo.getData();
                        XSheet.this.mbean = (XMBean)((Object[])attrData)[0];
                        final MBeanAttributeInfo mbai = (MBeanAttributeInfo)((Object[])attrData)[1];
                        final XMBeanAttributes mba = XSheet.this.mbeanAttributes;
                        try {
                            mba.loadAttributes(XSheet.this.mbean, new MBeanInfo(null, null, new MBeanAttributeInfo[]{mbai}, null, null, null));
                        }
                        catch (Exception e) {
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, e.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                            return;
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                XSheet.this.invalidate();
                                XSheet.this.mainPanel.removeAll();
                                JPanel attributePanel = new JPanel(new BorderLayout());
                                JPanel attributeBorderPanel = new JPanel(new BorderLayout());
                                attributeBorderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Attribute value", new Object[0])));
                                JPanel attributeValuePanel = new JPanel(new BorderLayout());
                                attributeValuePanel.setBorder(LineBorder.createGrayLineBorder());
                                attributeValuePanel.add((Component)mba.getTableHeader(), "First");
                                attributeValuePanel.add((Component)mba, "Center");
                                attributeBorderPanel.add((Component)attributeValuePanel, "Center");
                                JPanel refreshButtonPanel = new JPanel();
                                refreshButtonPanel.add(XSheet.this.refreshButton);
                                attributeBorderPanel.add((Component)refreshButtonPanel, "South");
                                XSheet.this.refreshButton.setEnabled(true);
                                attributePanel.add((Component)attributeBorderPanel, "North");
                                mbi.addMBeanAttributeInfo(mbai);
                                attributePanel.add((Component)mbi, "Center");
                                XSheet.this.mainPanel.add((Component)attributePanel, "Center");
                                XSheet.this.southPanel.setVisible(false);
                                XSheet.this.southPanel.removeAll();
                                XSheet.this.validate();
                                XSheet.this.repaint();
                            }
                        });
                    }
                });
                break;
            }
            case OPERATION: {
                Object operData = uo.getData();
                this.mbean = (XMBean)((Object[])operData)[0];
                MBeanOperationInfo mboi = (MBeanOperationInfo)((Object[])operData)[1];
                XMBeanOperations mbo = this.mbeanOperations;
                try {
                    mbo.loadOperations(this.mbean, new MBeanInfo(null, null, null, null, new MBeanOperationInfo[]{mboi}, null));
                }
                catch (Exception e) {
                    EventQueue.invokeLater(new ThreadDialog(this, e.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                this.invalidate();
                this.mainPanel.removeAll();
                JPanel operationPanel = new JPanel(new BorderLayout());
                JPanel operationBorderPanel = new JPanel(new BorderLayout());
                operationBorderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Operation invocation", new Object[0])));
                operationBorderPanel.add(new JScrollPane(mbo));
                operationPanel.add((Component)operationBorderPanel, "North");
                mbi.addMBeanOperationInfo(mboi);
                operationPanel.add((Component)mbi, "Center");
                this.mainPanel.add((Component)operationPanel, "Center");
                this.southPanel.setVisible(false);
                this.southPanel.removeAll();
                this.validate();
                this.repaint();
                break;
            }
            case NOTIFICATION: {
                Object notifData = uo.getData();
                this.invalidate();
                this.mainPanel.removeAll();
                mbi.addMBeanNotificationInfo((MBeanNotificationInfo)notifData);
                this.mainPanel.add((Component)mbi, "Center");
                this.southPanel.setVisible(false);
                this.southPanel.removeAll();
                this.validate();
                this.repaint();
            }
        }
    }

    private void displayMBeanAttributesNode(final DefaultMutableTreeNode node) {
        final XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.ATTRIBUTES)) {
            return;
        }
        final XMBeanAttributes mba = this.mbeanAttributes;
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = node;
                    XSheet.this.mbean = (XMBean)uo.getData();
                    mba.loadAttributes(XSheet.this.mbean, XSheet.this.mbean.getMBeanInfo());
                }
                catch (Throwable ex) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, ex.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel borderPanel = new JPanel(new BorderLayout());
                        borderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Attribute values", new Object[0])));
                        borderPanel.add(new JScrollPane(mba));
                        XSheet.this.mainPanel.add((Component)borderPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)XSheet.this.refreshButton, "South");
                        XSheet.this.southPanel.setVisible(true);
                        XSheet.this.refreshButton.setEnabled(true);
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayMBeanOperationsNode(final DefaultMutableTreeNode node) {
        final XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.OPERATIONS)) {
            return;
        }
        final XMBeanOperations mbo = this.mbeanOperations;
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = node;
                    XSheet.this.mbean = (XMBean)uo.getData();
                    mbo.loadOperations(XSheet.this.mbean, XSheet.this.mbean.getMBeanInfo());
                }
                catch (Throwable ex) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, ex.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel borderPanel = new JPanel(new BorderLayout());
                        borderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Operation invocation", new Object[0])));
                        borderPanel.add(new JScrollPane(mbo));
                        XSheet.this.mainPanel.add((Component)borderPanel, "Center");
                        XSheet.this.southPanel.setVisible(false);
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayMBeanNotificationsNode(final DefaultMutableTreeNode node) {
        final XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.NOTIFICATIONS)) {
            return;
        }
        final XMBeanNotifications mbn = this.mbeanNotifications;
        this.mbeansTab.workerAdd(new Runnable(){

            public void run() {
                try {
                    XSheet.this.node = node;
                    XSheet.this.mbean = (XMBean)uo.getData();
                    mbn.loadNotifications(XSheet.this.mbean);
                    XSheet.this.updateNotifications();
                }
                catch (Throwable ex) {
                    EventQueue.invokeLater(new ThreadDialog(XSheet.this, ex.getMessage(), Resources.getText("Problem displaying MBean", new Object[0]), 0));
                    return;
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel borderPanel = new JPanel(new BorderLayout());
                        borderPanel.setBorder(BorderFactory.createTitledBorder(Resources.getText("Notification buffer", new Object[0])));
                        borderPanel.add(new JScrollPane(mbn));
                        XSheet.this.mainPanel.add((Component)borderPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)XSheet.this.subscribeButton, "West");
                        XSheet.this.southPanel.add((Component)XSheet.this.unsubscribeButton, "Center");
                        XSheet.this.southPanel.add((Component)XSheet.this.clearButton, "East");
                        XSheet.this.southPanel.setVisible(true);
                        XSheet.this.subscribeButton.setEnabled(true);
                        XSheet.this.unsubscribeButton.setEnabled(true);
                        XSheet.this.clearButton.setEnabled(true);
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                });
            }
        });
    }

    private void displayEmptyNode() {
        this.invalidate();
        this.mainPanel.removeAll();
        this.southPanel.removeAll();
        this.validate();
        this.repaint();
    }

    private void registerListener() throws InstanceNotFoundException, IOException {
        this.mbeanNotifications.registerListener(this.node);
        this.updateNotifications();
        this.validate();
    }

    private void unregisterListener() {
        if (this.mbeanNotifications.unregisterListener(this.node)) {
            this.clearNotifications();
            this.validate();
        }
    }

    private void refreshAttributes() {
        this.mbeanAttributes.refreshAttributes();
    }

    private void updateNotifications() {
        if (this.mbean.isBroadcaster()) {
            if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
                long received = this.mbeanNotifications.getReceivedNotifications(this.mbean);
                this.updateReceivedNotifications(this.node, received, false);
            } else {
                this.clearNotifications();
            }
        } else {
            this.clearNotifications();
        }
    }

    private void updateReceivedNotifications(DefaultMutableTreeNode emitter, long received, boolean bold) {
        String text = Resources.getText("Notifications", new Object[0]) + "[" + received + "]";
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.mbeansTab.getTree().getLastSelectedPathComponent();
        if (bold && emitter != selectedNode) {
            text = "<html><b>" + text + "</b></html>";
        }
        this.updateNotificationsNodeLabel(emitter, text);
    }

    private void clearNotifications() {
        this.updateNotificationsNodeLabel(this.node, Resources.getText("Notifications", new Object[0]));
    }

    private void clearNotifications0() {
        this.updateNotificationsNodeLabel(this.node, Resources.getText("Notifications", new Object[0]) + "[0]");
    }

    private void updateNotificationsNodeLabel(final DefaultMutableTreeNode node, final String label) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                XTree xTree = XSheet.this.mbeansTab.getTree();
                synchronized (xTree) {
                    XSheet.this.invalidate();
                    XNodeInfo oldUserObject = (XNodeInfo)node.getUserObject();
                    XNodeInfo newUserObject = new XNodeInfo(oldUserObject.getType(), oldUserObject.getData(), label, oldUserObject.getToolTipText());
                    node.setUserObject(newUserObject);
                    DefaultTreeModel model = (DefaultTreeModel)XSheet.this.mbeansTab.getTree().getModel();
                    model.nodeChanged(node);
                    XSheet.this.validate();
                    XSheet.this.repaint();
                }
            }
        });
    }

    private void clearCurrentNotifications() {
        this.mbeanNotifications.clearCurrentNotifications();
        if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
            this.clearNotifications0();
        } else {
            this.clearNotifications();
        }
    }

    private void clear() {
        this.mbeanAttributes.stopCellEditing();
        this.mbeanAttributes.emptyTable();
        this.mbeanAttributes.removeAttributes();
        this.mbeanOperations.removeOperations();
        this.mbeanNotifications.stopCellEditing();
        this.mbeanNotifications.emptyTable();
        this.mbeanNotifications.disableNotifications();
        this.mbean = null;
        this.node = null;
    }

    public void handleNotification(Notification e, Object handback) {
        if (e.getType().equals("jam.xoperations.invoke.result")) {
            Component message;
            if (handback == null) {
                JTextArea textArea = new JTextArea("null");
                textArea.setEditable(false);
                textArea.setEnabled(true);
                textArea.setRows(textArea.getLineCount());
                message = textArea;
            } else {
                Component comp = this.mbeansTab.getDataViewer().createOperationViewer(handback, this.mbean);
                if (comp == null) {
                    JTextArea textArea = new JTextArea(handback.toString());
                    textArea.setEditable(false);
                    textArea.setEnabled(true);
                    textArea.setRows(textArea.getLineCount());
                    JScrollPane scrollPane = new JScrollPane(textArea);
                    Dimension d = scrollPane.getPreferredSize();
                    if (d.getWidth() > 400.0 || d.getHeight() > 250.0) {
                        scrollPane.setPreferredSize(new Dimension(400, 250));
                    }
                    message = scrollPane;
                } else {
                    Dimension d;
                    if (!(comp instanceof JScrollPane)) {
                        comp = new JScrollPane(comp);
                    }
                    if ((d = comp.getPreferredSize()).getWidth() > 400.0 || d.getHeight() > 250.0) {
                        comp.setPreferredSize(new Dimension(400, 250));
                    }
                    message = comp;
                }
            }
            EventQueue.invokeLater(new ThreadDialog((Component)e.getSource(), message, Resources.getText("Operation return value", new Object[0]), 1));
        } else if (e.getType().equals("jconsole.xnotification.received")) {
            DefaultMutableTreeNode emitter = (DefaultMutableTreeNode)handback;
            Long received = (Long)e.getUserData();
            this.updateReceivedNotifications(emitter, received, true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (button == this.refreshButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        XSheet.this.refreshAttributes();
                    }
                });
                return;
            }
            if (button == this.clearButton) {
                this.clearCurrentNotifications();
                return;
            }
            if (button == this.subscribeButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            XSheet.this.registerListener();
                        }
                        catch (Throwable ex) {
                            ex = Utils.getActualException(ex);
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, ex.getMessage(), Resources.getText("Problem adding listener", new Object[0]), 0));
                        }
                    }
                });
                return;
            }
            if (button == this.unsubscribeButton) {
                this.mbeansTab.workerAdd(new Runnable(){

                    public void run() {
                        try {
                            XSheet.this.unregisterListener();
                        }
                        catch (Throwable ex) {
                            ex = Utils.getActualException(ex);
                            EventQueue.invokeLater(new ThreadDialog(XSheet.this, ex.getMessage(), Resources.getText("Problem removing listener", new Object[0]), 0));
                        }
                    }
                });
                return;
            }
        }
    }
}

