/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecureRandom
extends SecureRandomSpi {
    private static final long serialVersionUID = -8939510236124553291L;
    private final Token token;
    private volatile SecureRandom mixRandom;
    private byte[] mixBuffer;
    private int buffered;
    private static final long MAX_IBUFFER_TIME = 100L;
    private static final int IBUFFER_SIZE = 32;
    private transient byte[] iBuffer = new byte[32];
    private transient int ibuffered = 0;
    private transient long lastRead = 0L;

    P11SecureRandom(Token token) {
        this.token = token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void engineSetSeed(byte[] seed) {
        block9: {
            if (seed == null) {
                throw new NullPointerException("seed must not be null");
            }
            Session session = null;
            try {
                session = this.token.getOpSession();
                this.token.p11.C_SeedRandom(session.id(), seed);
            }
            catch (PKCS11Exception e) {
                SecureRandom random = this.mixRandom;
                if (random != null) {
                    random.setSeed(seed);
                    break block9;
                }
                try {
                    this.mixBuffer = new byte[20];
                    random = SecureRandom.getInstance("SHA1PRNG");
                    random.setSeed(seed);
                    this.mixRandom = random;
                }
                catch (NoSuchAlgorithmException ee) {
                    throw new ProviderException(ee);
                }
            }
            finally {
                this.token.releaseSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (bytes.length <= 32) {
            int ofs = 0;
            byte[] byArray = this.iBuffer;
            synchronized (this.iBuffer) {
                while (ofs < bytes.length) {
                    long time = System.currentTimeMillis();
                    if (this.ibuffered == 0 || time - this.lastRead >= 100L) {
                        this.lastRead = time;
                        this.implNextBytes(this.iBuffer);
                        this.ibuffered = 32;
                    }
                    while (ofs < bytes.length && this.ibuffered > 0) {
                        bytes[ofs++] = this.iBuffer[32 - this.ibuffered--];
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            this.implNextBytes(bytes);
        }
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] b = new byte[numBytes];
        this.engineNextBytes(b);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mix(byte[] b) {
        SecureRandom random = this.mixRandom;
        if (random == null) {
            return;
        }
        P11SecureRandom p11SecureRandom = this;
        synchronized (p11SecureRandom) {
            int ofs = 0;
            int len = b.length;
            while (len-- > 0) {
                if (this.buffered == 0) {
                    random.nextBytes(this.mixBuffer);
                    this.buffered = this.mixBuffer.length;
                }
                int n = ofs++;
                b[n] = (byte)(b[n] ^ this.mixBuffer[this.mixBuffer.length - this.buffered]);
                --this.buffered;
            }
        }
    }

    private void implNextBytes(byte[] bytes) {
        Session session = null;
        try {
            session = this.token.getOpSession();
            this.token.p11.C_GenerateRandom(session.id(), bytes);
            this.mix(bytes);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("nextBytes() failed", e);
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.iBuffer = new byte[32];
        this.ibuffered = 0;
        this.lastRead = 0L;
    }
}

