/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.pkcs11.SessionRef;
import sun.security.pkcs11.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Session
implements Comparable<Session> {
    private static final long MAX_IDLE_TIME = 180000L;
    final Token token;
    private final long id;
    private final AtomicInteger createdObjects;
    private long lastAccess;
    private final SessionRef sessionRef;

    Session(Token token, long id) {
        this.token = token;
        this.id = id;
        this.createdObjects = new AtomicInteger();
        this.id();
        this.sessionRef = new SessionRef(this, id, token);
    }

    @Override
    public int compareTo(Session other) {
        if (this.lastAccess == other.lastAccess) {
            return 0;
        }
        return this.lastAccess < other.lastAccess ? -1 : 1;
    }

    boolean isLive(long currentTime) {
        return currentTime - this.lastAccess < 180000L;
    }

    long idInternal() {
        return this.id;
    }

    long id() {
        if (!this.token.isPresent(this)) {
            throw new ProviderException("Token has been removed");
        }
        this.lastAccess = System.currentTimeMillis();
        return this.id;
    }

    void addObject() {
        int n = this.createdObjects.incrementAndGet();
    }

    void removeObject() {
        int n = this.createdObjects.decrementAndGet();
        if (n == 0) {
            this.token.sessionManager.demoteObjSession(this);
        } else if (n < 0) {
            throw new ProviderException("Internal error: objects created " + n);
        }
    }

    boolean hasObjects() {
        return this.createdObjects.get() != 0;
    }

    void close() {
        if (this.hasObjects()) {
            throw new ProviderException("Internal error: close session with active objects");
        }
        this.sessionRef.dispose();
    }
}

