/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.beans.BeanDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class BeanInfoUtils {
    public static final String BOUND = "bound";
    public static final String CONSTRAINED = "constrained";
    public static final String PROPERTYEDITORCLASS = "propertyEditorClass";
    public static final String READMETHOD = "readMethod";
    public static final String WRITEMETHOD = "writeMethod";
    public static final String DISPLAYNAME = "displayName";
    public static final String EXPERT = "expert";
    public static final String HIDDEN = "hidden";
    public static final String PREFERRED = "preferred";
    public static final String SHORTDESCRIPTION = "shortDescription";
    public static final String CUSTOMIZERCLASS = "customizerClass";

    private static void initFeatureDescriptor(FeatureDescriptor fd, String key, Object value) {
        if (DISPLAYNAME.equals(key)) {
            fd.setDisplayName((String)value);
        }
        if (EXPERT.equals(key)) {
            fd.setExpert((Boolean)value);
        }
        if (HIDDEN.equals(key)) {
            fd.setHidden((Boolean)value);
        }
        if (PREFERRED.equals(key)) {
            fd.setPreferred((Boolean)value);
        } else if (SHORTDESCRIPTION.equals(key)) {
            fd.setShortDescription((String)value);
        } else {
            fd.setValue(key, value);
        }
    }

    public static PropertyDescriptor createPropertyDescriptor(Class cls, String name, Object[] args) {
        PropertyDescriptor pd = null;
        try {
            pd = new PropertyDescriptor(name, cls);
        }
        catch (IntrospectionException e) {
            try {
                pd = BeanInfoUtils.createReadOnlyPropertyDescriptor(name, cls);
            }
            catch (IntrospectionException ie) {
                BeanInfoUtils.throwError(ie, "Can't create PropertyDescriptor for " + name + " ");
            }
        }
        for (int i = 0; i < args.length; i += 2) {
            Method method;
            String methodName;
            String key = (String)args[i];
            Object value = args[i + 1];
            if (BOUND.equals(key)) {
                pd.setBound((Boolean)value);
                continue;
            }
            if (CONSTRAINED.equals(key)) {
                pd.setConstrained((Boolean)value);
                continue;
            }
            if (PROPERTYEDITORCLASS.equals(key)) {
                pd.setPropertyEditorClass((Class)value);
                continue;
            }
            if (READMETHOD.equals(key)) {
                methodName = (String)value;
                try {
                    method = cls.getMethod(methodName, new Class[0]);
                    pd.setReadMethod(method);
                }
                catch (Exception e) {
                    BeanInfoUtils.throwError(e, cls + " no such method as \"" + methodName + "\"");
                }
                continue;
            }
            if (WRITEMETHOD.equals(key)) {
                methodName = (String)value;
                try {
                    Class<?> type = pd.getPropertyType();
                    method = cls.getMethod(methodName, type);
                    pd.setWriteMethod(method);
                }
                catch (Exception e) {
                    BeanInfoUtils.throwError(e, cls + " no such method as \"" + methodName + "\"");
                }
                continue;
            }
            BeanInfoUtils.initFeatureDescriptor(pd, key, value);
        }
        return pd;
    }

    public static BeanDescriptor createBeanDescriptor(Class cls, Object[] args) {
        Class customizerClass = null;
        for (int i = 0; i < args.length; i += 2) {
            if (!CUSTOMIZERCLASS.equals((String)args[i])) continue;
            customizerClass = (Class)args[i + 1];
            break;
        }
        BeanDescriptor bd = new BeanDescriptor(cls, customizerClass);
        for (int i = 0; i < args.length; i += 2) {
            String key = (String)args[i];
            Object value = args[i + 1];
            BeanInfoUtils.initFeatureDescriptor(bd, key, value);
        }
        return bd;
    }

    private static PropertyDescriptor createReadOnlyPropertyDescriptor(String name, Class cls) throws IntrospectionException {
        Method readMethod = null;
        String base = BeanInfoUtils.capitalize(name);
        Class[] parameters = new Class[]{};
        try {
            readMethod = cls.getMethod("is" + base, parameters);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (readMethod == null) {
            try {
                readMethod = cls.getMethod("get" + base, parameters);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
        if (readMethod != null) {
            return new PropertyDescriptor(name, readMethod, null);
        }
        try {
            parameters = new Class[]{Integer.TYPE};
            readMethod = cls.getMethod("get" + base, parameters);
        }
        catch (NoSuchMethodException nsme) {
            throw new IntrospectionException("cannot find accessor method for " + name + " property.");
        }
        return new IndexedPropertyDescriptor(name, null, null, readMethod, null);
    }

    private static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static void throwError(Exception e, String s) {
        throw new Error(e.toString() + " " + s);
    }
}

