/*
 * Copyright 2007 Accu-Time Systems, Inc.  All rights reserved.
 *
 *                            DISCLAIMER
 * NO WARRANTIES
 * Accu-Time Systems expressly disclaims any warranty for the SOFTWARE
 * PRODUCT. The SOFTWARE PRODUCT and any related documentation is
 * provided "as is" without warranty of any kind, either expressed or
 * implied, including, without limitation, the implied warranties or
 * merchantability, fitness for a particular purpose, or noninfringe-
 * ment. The entire risk arising out of the use or performance of the
 * SOFTWARE PRODUCT remains with the user.
 *
 * NO LIABILITY FOR DAMAGES.
 * Under no circumstances is Accu-Time Systems liable for any damages
 * whatsoever (including, without limitation, damages for loss of busi-
 * ness profits, business interruption, loss of business information,
 * or any other pecuniary loss) arising out of the use of or inability
 * to use this product.
 *
 */

package com.accu_time.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import com.accu_time.device.Badge;
import com.accu_time.device.BadgeEvent;
import com.accu_time.device.BadgeListener;
import com.accu_time.device.BadgeReader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BadgeTest implements BadgeListener {
	private List _badges = new ArrayList();

	public void badgeReceived(BadgeEvent event) {
		Badge badge = event.badge();

		System.out.println("");
		System.out.println("Recieved badge input:");
		System.out.println(" Port: " + event.getPort());
		
		switch(event.getType()) {
			case BadgeEvent.Medium.OPTICAL:
				System.out.println(" Type: Optical");
				break;
			case BadgeEvent.Medium.WIEGAND:
				System.out.println(" Type: Wiegand");
				break;
			case BadgeEvent.Medium.MAGNETIC:
				System.out.println(" Type: Magnetic");
				break;
			case BadgeEvent.Medium.INVALID:
				System.out.println(" Type: Invalid");
				break;
		}
		
		System.out.println("Value: " + badge.getValue());
		System.out.println("  Raw: " + badge.getRaw());
		
		if (event.getType() != BadgeEvent.Medium.INVALID)
			_badges.add(badge);
	}
	
	public void menu(String path) throws Exception{
		BadgeReader reader = new BadgeReader(path);
		reader.addBadgeListener((BadgeListener) this);
		reader.start();

		BufferedReader in = new BufferedReader(
		                        new InputStreamReader(System.in));

		System.out.println("Queuing badges");
		System.out.println("l) list badges");
		System.out.println("q) quit");
		do {
			System.out.println("");
			System.out.print("> ");
			String choice = in.readLine();
			
			if (choice.equals("l")) {
				System.out.println("Queued badges");

				Iterator badges = _badges.iterator();
				while (badges.hasNext()) {
					System.out.println("Badge: " + 
					                   ((Badge) badges.next()).getValue());
				}
			}
			
			if (choice.equals("q")) {
				System.out.println("Exiting");
				reader.shutdown();
				System.exit(0);
			}
		} while (true);
	}
	
	public static void main(String[] args) throws Exception {
		BadgeTest test = new BadgeTest();
		test.menu(args[0]);
	}
}

