/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
| © 2011 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

// Hello World w/ resize key (F1/F2) and exit key (F8)
//

package com.accu_time.test;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.accu_time.util.*;

public class HelloWorld extends JPanel implements KeyListener
{
    static JFrame frame;
    static HelloWorld world;
    JLabel helloWorld;
    static String display_type;
    
    public HelloWorld()
    {
        BorderLayout bl = new BorderLayout();
        this.setLayout(bl);
        helloWorld = new JLabel("Hello World!");
        add(helloWorld, BorderLayout.CENTER);
        this.validate();
    }

    public static HelloWorld makePanel()
    {
        Rectangle default_bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        System.out.println("default_bounds="+default_bounds);
        frame = new JFrame("HelloWorld");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        world = new HelloWorld();
        frame.addKeyListener(world);
        frame.add(world);
        frame.setSize(default_bounds.width, default_bounds.height);
        world.setPreferredSize(frame.getSize());
        frame.pack();
        world.helloWorld.requestFocusInWindow();
        //transparent_cursor(frame);
        frame.setVisible(true);
        frame.toFront();
        System.out.println("about to beep");
        java.awt.Toolkit.getDefaultToolkit().beep();
        System.out.println("beep attempted");
        return world;
    }

    public final int MX_F1_KEY = 121;
    public final int OPT_F1_KEY = 65;
    public final int MX_F2_KEY = 37;
    public final int OPT_F2_KEY = 66;
    public final int MX_F8_KEY = 72;
    public void keyPressed(KeyEvent event)
    {
        System.out.println("Key Code = " + event.getKeyCode());
        Font wasFont = helloWorld.getFont();
        if (event.getKeyCode() == MX_F1_KEY || event.getKeyCode() == OPT_F1_KEY)
        {
            float newSize = wasFont.getSize() + 1.0f;
            helloWorld.setFont(wasFont.deriveFont(newSize));
            System.out.println("font size now " + newSize);
        }
        else if (event.getKeyCode() == MX_F2_KEY || event.getKeyCode() == OPT_F2_KEY)
        {
            float newSize = wasFont.getSize() - 1.0f;
            helloWorld.setFont(wasFont.deriveFont(newSize));
            System.out.println("font size now " + newSize);
        }
        else if (event.getKeyCode() == MX_F8_KEY)
        {
            System.exit(0);
        }
    }

    public void keyReleased(KeyEvent event)
    {
        Toolkit.getDefaultToolkit().beep();
    }

    public void keyTyped(KeyEvent event) {
        System.out.println("Key Char = '" + event.getKeyChar() + "'");
    }

    public static void main(String[] args) throws Exception
    {
        display_type = new TextFileDeviceIO("/dev/atsconfig").readValue("displaytype");
        System.out.println("display_type=" + display_type);
        javax.swing.SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                HelloWorld panel = makePanel();
            }
        });
    }
}
