/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

package com.accu_time.test;

import com.accu_time.util.Dbg;
import com.accu_time.util.TextFileDeviceIO;
import java.lang.reflect.*;
import java.io.*;

public class JavaGlobalExerciser implements Runnable{
	static TextFileDeviceIO leds;
	static TextFileDeviceIO cfgs;
	static boolean attemptingRun = false;
	boolean passed = false;

	JavaGlobalExerciser(String class_to_run)	{
		Class c;
		if (class_to_run == null) {
			c = this.getClass();
		} else try {
			c = (Class)Class.forName(class_to_run);
		} catch (ClassNotFoundException ex) {
			Dbg.out("Could not find class " + class_to_run);
			c = this.getClass();
		}
		if (leds == null) {
			leds = new TextFileDeviceIO("/dev/atsleds");
		}
		if (cfgs == null) {
			cfgs = new TextFileDeviceIO("/dev/atsconfig");
		}
		try {
			System.out.println("c = "+c+" name='" + c.getName()+"'");
			Constructor[] ctors = c.getConstructors();
			System.out.println("ctors="+ctors);
			System.out.println("ctors.length="+ctors.length);
			Constructor ctor = null;
			for (int i=0; i<ctors.length; i++) {
				System.out.println("ctors["+i+"] = "+ctors[i]);
				if (ctors[i].getParameterTypes().length == 0) {
					ctor = ctors[i];
					break;
				}
			}
			System.out.println("ctor = "+ctor);
			if (!attemptingRun) {
				attemptingRun = true;
				Runnable toRun = (Runnable)ctor.newInstance(null);
				System.out.println("toRun = "+toRun);
				toRun.run();
			}
		} catch (Exception ex) {
			Dbg.out("JavaGlobalExerciser failed to run class " + c.getName());
			Dbg.pst(ex);
		}
	}

	public JavaGlobalExerciser() {
		this(null);
	}

    public static void main(String[] args) {
		Runtime runtime = Runtime.getRuntime();
		System.out.println("main exerciseOutOfMemory Runtime.getRuntime=" + runtime);
		System.out.println("freeMemory="+runtime.freeMemory()+" totalMemory="+runtime.totalMemory());
		if (args.length > 1) {
			System.out.println("usage: JavaGlobalExerciser [class_to_run]");
			return;
		}
		String class_to_run;
		if (args.length == 0) {
			class_to_run = "JavaGlobalExerciser";
		} else {
			class_to_run = args[0];
		}
		System.loadLibrary("GlobalJNI");
		new JavaGlobalExerciser(class_to_run);
	}

	public void run() {
		int exercisesAttempted = 0;
		int exercisesPassed = 0;
		exercisesPassed += exerciseOutOfMemory()?1:0;
		exercisesAttempted++;
		exercisesPassed += exerciseWorkerThread()?1:0;
		exercisesAttempted++;
		exercisesPassed += exerciseFloatingPoint()?1:0;
		exercisesAttempted++;
		exercisesPassed += exerciseShellFileIO()?1:0;
		exercisesAttempted++;
		exercisesPassed += exercisePing()?1:0;
		exercisesAttempted++;
//		exercisesPassed += exerciseSqlLiteViaJDBC()?1:0;
//		exercisesAttempted++;
		passed = exercisesPassed < exercisesAttempted;
		System.out.println(exercisesPassed + " of " + exercisesAttempted + " tests passed.");
	}

	static boolean exerciseLoadableRunnable(String className) {
		System.out.println("Should load class " + className + ".class");
		return false;
	}

	static boolean exerciseOutOfMemory() {
		Runtime runtime = Runtime.getRuntime();
		System.out.println("exerciseOutOfMemory Runtime.getRuntime=" + runtime);
//		try {
//			System.out.println("maxMemory="+runtime.maxMemory());
//		} catch (java.lang.NoSuchMethodError err) {
//			System.out.println("NoSuchMethodError Problem calling maxMemory()");
//			Dbg.pst();
//		}
		long initialTotalMemory = runtime.totalMemory();
		System.out.println("freeMemory="+runtime.freeMemory()+" totalMemory="+initialTotalMemory);
		Object [] chainedAllocates = null;
		Object chainTo = null;
		int i=1;
		int p=1;
		try {
			for (i=1; true; i++) {
				chainTo = (Object)chainedAllocates;
				p+=p;
				chainedAllocates = new Object [p];
				if (initialTotalMemory != runtime.totalMemory()) {
					System.out.println("2^i="+p+ " freeMemory="+runtime.freeMemory());
					System.out.println("totalMemory="+runtime.totalMemory());
				}
				chainedAllocates[0] = chainTo;
				chainedAllocates[1] = (Object)chainedAllocates;
			}
		} catch (OutOfMemoryError e) {
			System.out.println("Got error " + e);
			chainedAllocates = null;
			chainTo = null;
		}
		System.out.println("freeMemory="+runtime.freeMemory()+" totalMemory="+runtime.totalMemory());
		chainTo = (Object)new Object [p/2];
		System.out.println("after creating "+chainTo+", freeMemory="+runtime.freeMemory()+" totalMemory="+runtime.totalMemory());
		chainTo = null;
		runtime.gc();
		System.out.println("after garbage collection, freeMemory="+runtime.freeMemory()+" totalMemory="+runtime.totalMemory());
		return true;
	}

	final static int maxThreads = 5000;
	final static int [] digitCounts = new int [10];
	final static Object [] digitCountGuards = new Object [10];
	{
		for (int i=0; i<10; i++) {
			digitCountGuards[i] = new Object();
		}
	}
	private static class SeededWorker implements Runnable {
		double seed = 1.0;
		public void run() {
			double a = seed;
			int digit = (int)seed;
			if (digit < 5) {
				Thread.yield();
			}
			for (int i=0; i<10; i++) {
				a *= 10.0;
				digit = (int)a;
				a -= (double)digit;
			}
			// digit is the 10th digit of the random number
			synchronized (digitCountGuards[digit]) {
				digitCounts[digit]++;
			}
		}
		public void setSeed(double seed) {
			this.seed = seed;
		}
	}

	static boolean exerciseWorkerThread() {
		SeededWorker worker;
		Thread [] workerThreads = new Thread [maxThreads];
		int i;
		int started = 0;
		for (i=0; i<maxThreads; i++) {
			Thread workerThread;
			try {
				worker = new SeededWorker();
				workerThread = new Thread(worker);
				workerThreads[i] = workerThread;
			} catch (Exception ex) {
				System.out.println("Exception "+ex+" after creating "+i+" threads.");
				break;
			}
			worker.setSeed(java.lang.Math.random());
			workerThread.start();
			started++;
		}
		System.out.println("Waiting for "+started+" threads to complete at "+System.currentTimeMillis());
		try {
			boolean anyAlive = true;
			int oldFoundAlive = 0;
			while (anyAlive) {
				int foundAlive = 0;
				for (int j=0; j<started; j++) {
					if (workerThreads[j] != null) {
						if (workerThreads[j].isAlive()) {
							foundAlive++;
						} else {
							workerThreads[j] = null;
						}
					}
				}
				anyAlive = (foundAlive > 0);
				if (foundAlive != oldFoundAlive) {
					oldFoundAlive = foundAlive;
					System.out.println(foundAlive +" threads still alive at "+System.currentTimeMillis());
				}
			}
		} catch (Exception ex) {
			Dbg.pst(ex);
			return false;
		}
		for (int d=0; d<10; d++) {
			System.out.println("digit " + d + " hits " + digitCounts[d]);
		}
		System.out.println("exerciseWorkerThread() completed successfully");
		return true;
	}

	static boolean exerciseFloatingPoint() {
		try {
			System.out.println("pi = " + java.lang.Math.PI);
			System.out.println("e = " + java.lang.Math.E);
			System.out.println("e^2PI = " + java.lang.Math.pow(java.lang.Math.E, 2.0*java.lang.Math.PI));
			double nearPi=3.14159265;
			System.out.println("nearPi=" + nearPi);
			int [] expected = new int [] {3,1,4,1,5,9,2,6,5};
			int [] converted = new int [expected.length];
			double a = nearPi;
			System.out.print("converted digits = ");
			for (int i=0; i<converted.length; i++) {
				int digit = (int)a;
				a = (a-(double)digit)*10.0;
				converted[i] = digit;
				System.out.print(digit);
				if (i==0) {
					System.out.print(".");
				}
			}
			System.out.println();
			for (int i=0; i<converted.length; i++) {
				if (expected[i] != converted[i]) {
					System.out.println("converted digits test failed");
					return false;
				}
			}
			if (!Double.toString(nearPi).equals("3.14159265")) {
				System.out.println("Double.toString(nearPi)="+Double.toString(nearPi) + " vs \"3.14159265\" test failed");
				return false;
			}
			System.out.println("exerciseWorkerThread() completed successfully");
			return true;
		} catch (Exception ex) {
			Dbg.pst(ex);
			return false;
		}
	}

	static boolean exerciseShellFileIO() {
		try {
			File exercise = new File("/release/examples/Demo", "exercise.tmp");
			if (exercise.exists()) {
				exercise.delete();
			}
			exercise.createNewFile();
			System.out.println(exercise + " created; writeable=" + exercise.canWrite());
			File directory = new File("/release/examples/Demo", "intermediate/exercise.dir");
			directory.mkdirs();
			exercise.renameTo(new File("intermediate/exercise.dir/changed"));
			String shellFileName = "/release/examples/Demo/intermediate/doalisting";
			File shellFile = new File(shellFileName);
			String listingFileName = "/release/examples/Demo/intermediate/exercise.dir/listing";
			BufferedWriter bw = new BufferedWriter(new FileWriter(shellFileName));
			String shellFileContents = "/bin/ls -l /release/examples/Demo/intermediate/exercise.dir >> " +
			                           listingFileName;
			bw.write(shellFileContents);
			bw.newLine();
			bw.close();

			String cmd = "sh " + shellFileName;
			Process pr = Runtime.getRuntime().exec(cmd);
			System.out.println(pr.waitFor() + " = exec(" + cmd + ")");
			BufferedReader br = new BufferedReader(new FileReader(listingFileName));
			String fromExec = br.readLine();
			System.out.println("From doalisting:");
			while (fromExec != null) {
				System.out.println(fromExec);
				fromExec = br.readLine();
			}
			File [] inside = directory.listFiles();
			System.out.println("In directory " + directory + ":");
			for (int i=0; i<inside.length; i++) {
				System.out.println("    deleting " + inside[i]);
				inside[i].delete();
			}
			File parent = directory.getParentFile();
//			exercise = null; // remove reference
//			br = null;
			System.out.println("deleting " + shellFileName);
			shellFile.delete();
			directory.delete();
			parent.delete();
//			shellFile = null;
//			Runtime.getRuntime().gc(); // clean up reference
//			Dbg.wait(30);
//			System.out.println("Execing /bin/rmdir " + directory.toString());
//			shellFileName = "/release/examples/Demo/intermediate/deleteadir";
//			shellFile = new File(shellFileName);
//			bw = new BufferedWriter(new FileWriter(shellFileName));
//			shellFileContents = "/bin/rmdir " + directory.toString();
//			bw.write(shellFileContents);
//			bw.newLine();
//			bw.close();
//			cmd = "sh " + shellFileName;
//			pr = Runtime.getRuntime().exec(cmd);
//			System.out.println(pr.waitFor() + " = exec(" + cmd + ")");
//			shellFile.delete();
//			System.out.println("deleting " + directory);
//			directory.delete();
//			directory = null;
//			Runtime.getRuntime().gc(); // clean up reference
//			System.out.println("Execing /bin/rmdir " + parent.toString());
//			shellFileName = "/release/examples/Demo/deleteadir";
//			shellFile = new File(shellFileName);
//			bw = new BufferedWriter(new FileWriter(shellFileName));
//			shellFileContents = "/bin/rmdir " + parent.toString();
//			bw.write(shellFileContents);
//			bw.newLine();
//			bw.close();
//			cmd = "sh " + shellFileName;
//			pr = Runtime.getRuntime().exec(cmd);
//			System.out.println(pr.waitFor() + " = exec(" + cmd + ")");
//			shellFile.delete();
//			System.out.println("deleting " + parent);
//			parent.delete();
//			directory = new File("/ucs");
//			br = new BufferedReader(new FileReader(new File(directory, "results.log")));
//			String fromLog = br.readLine();
//			System.out.println("From UCS Log:");
//			for (int i=0; i<10 && fromLog != null; i++) {
//				System.out.println(fromLog);
//				fromLog = br.readLine();
//			}
//			br.close();
//			directory = new File("/release/examples/Demo/restricted");
//			exercise = new File(directory, "disallowed");
//			try {
//				bw = new BufferedWriter(new FileWriter(exercise));
//			} catch (java.io.FileNotFoundException ex) {
//				if (ex.toString().indexOf("Permission denied") != -1) {
//					System.out.println("Expected exception (" + ex + ") seen when trying to create " + exercise);
//				} else {
//					return false;
//				}
//			}
		} catch (Exception ex) {
			Dbg.pst(ex);
			return false;
		}
		return true;
	}

	static boolean exercisePing() {
		String cmd = "/bin/ping -c 2 accutime.com";
		try {
			Runtime rt = Runtime.getRuntime();
			Process pr = rt.exec(cmd);
			BufferedReader br = new BufferedReader(new InputStreamReader(pr.getInputStream(), "US-ASCII"));
			int pingRetCode = pr.waitFor();
			if (pingRetCode != 0) {
				return false;
			}
			String pingOutput = null;
			boolean roundTripSeen = false;
			while (null != (pingOutput = br.readLine())) {
				System.out.println(pingOutput);
				roundTripSeen |= (-1 != pingOutput.indexOf("1 packets received") ||
								  -1 != pingOutput.indexOf("2 packets received"));
			}
			br.close();
			return roundTripSeen;
		} catch (Exception ex) {
			Dbg.pst(ex);
			return false;
		}
	}

	static boolean exerciseSqlLiteViaJDBC() {
		try {
		} catch (Exception ex) {
			Dbg.pst(ex);
			return false;
		}
		return true;
	}
}
