/*
+====================================================================+
|Global Terminal                                                      |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
| © 2009 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/
package com.accu_time.test;

import com.accu_time.util.BiometricAPI;
import com.accu_time.util.BiometricAPI.*;
import com.accu_time.util.BiometricAPIviaJNI;
import com.accu_time.util.MQ;
import java.io.*;


public class TestFingerprints {
	private static BufferedReader stdin = new BufferedReader( new InputStreamReader( System.in ) );

	public static void main(String args[]) throws IOException, NumberFormatException {
		int errCode = BiometricAPI.BIOAPI_INVALID;
		int devType = -1;
		if (args.length == 1 && args[0].equalsIgnoreCase("Cogent")) {
			devType = BiometricAPI.BIOAPI_COGENT;
		} else if (args.length == 1 && args[0].equalsIgnoreCase("Bioscrypt")) {
			devType = BiometricAPI.BIOAPI_BIOSCRYPT;
		} else if (args.length == 1 && args[0].equalsIgnoreCase("Suprema")) {
			devType = BiometricAPI.BIOAPI_SUPREMA;
		}
		if (devType == -1) {
			System.out.println("Usage:\n" +
							   "sh test.sh FingerprintTests Cogent|Bioscrypt|Suprema");
			return;
		}
		BioscryptQuality_struct bioscryptQuality = new BioscryptQuality_struct();
		System.loadLibrary("ATSJavaAPI");
		BiometricAPIviaJNI bio = new BiometricAPIviaJNI();
		IntPass ip = new IntPass();
		errCode = bio.BioInitialization(ip, devType, (byte)3);
		if (errCode != BiometricAPI.BIOAPI_OK) {
			System.out.println("Couldn't initialize fingerprint reader err= " + bio.errString(errCode));
			return;
		}
		int handle = ip.i;
		errCode = bio.BioDeviceResponsive(handle);
		if (errCode != BiometricAPI.BIOAPI_OK) {
			System.out.println("Couldn't talk to fingerprint reader");
			return;
		}
		StringPass versionString = new StringPass();
		errCode = bio.BioGetVersionString(handle, versionString);
		if (errCode != BiometricAPI.BIOAPI_OK) {
			System.out.println("Couldn't talk correctly to fingerprint reader");
			return;
		}
		System.out.println("finger print reader version = " + versionString.s);
		BytePass bp = new BytePass();
		if (devType == BiometricAPI.BIOAPI_BIOSCRYPT) {
			bioscryptQuality = new BioscryptQuality_struct();
			bioscryptQuality.content = 0;
			bioscryptQuality.quality = 0;
			bioscryptQuality.contentThresholds = new byte [] {80, 60, 40};
			bioscryptQuality.qualityThresholds = new byte [] {40, 60, 80};
			System.out.println("Using content thresholds {" +
				bioscryptQuality.contentThresholds[0] + ", " +
				bioscryptQuality.contentThresholds[1] + ", " +
				bioscryptQuality.contentThresholds[2] + "}");
			System.out.println("Using quality thresholds {" +
				bioscryptQuality.qualityThresholds[0] + ", " +
				bioscryptQuality.qualityThresholds[1] + ", " +
				bioscryptQuality.qualityThresholds[2] + "}");
		}
		while (true)
		{
			System.out.println("Action: 0=quit, 1=enroll, 2=verify, 3=list, 4=delete");
			String fromConsole = stdin.readLine();
			if (fromConsole.equals("0"))
			{
				System.out.println("exiting");
				break;
			}
			else if (fromConsole.equals("1"))
			{
				System.out.println("badge number?");
				fromConsole = stdin.readLine();
				int badgeNumber;
				try {
					badgeNumber = Integer.parseInt(fromConsole);
				} catch (Exception ex) {
					System.out.println("bad badge number exception="+ex);
					continue;
				}
			        int [] badgeNumberList = { badgeNumber };
				byte [] indexNumberList = null;
				int index = 0;
				errCode = bio.BioAreTemplateIdsPresent(handle, badgeNumberList, indexNumberList, ip);
				if (errCode != BiometricAPI.BIOAPI_OK)
				{
					System.out.println("error: " + bio.errString(errCode) + " = BioAreTemplateIdsPresent(handle, badgeNumberList, indexNumberList, ip)");
					continue;
				}
				if (ip.i == 0)
				{
					System.out.println("Enroll a finger for badge number " + badgeNumber + " (primary)");
				}
				else
				{
					System.out.println("Enroll primary=0 or secondary=1?");
					fromConsole = stdin.readLine();
					if (fromConsole.equals("0"))
					{
						index = 0;
					}
					else if (fromConsole.equals("1"))
					{
						index = 1;
					}
					else
					{
						System.out.println("Unknown index");
						continue;
					}
				}
				System.out.println("Present finger to enroll");
				// different enroll if Bioscrypt
				if (devType == BiometricAPI.BIOAPI_COGENT || devType == BiometricAPI.BIOAPI_SUPREMA)
				{
					errCode = bio.BioEnroll(handle, badgeNumber, (byte)index, bp);
					if (errCode != BiometricAPI.BIOAPI_OK)
					{
						System.out.println("error: " + bio.errString(errCode) + " = bio.BioEnroll(handle, badgeNumber, (byte)index, bp)");
						continue;
					}
					System.out.println("quality = " + bp.b);
				} else if (devType == BiometricAPI.BIOAPI_BIOSCRYPT) {
					errCode = bio.BioEnroll(handle, badgeNumber, (byte)index, bioscryptQuality);
					if (errCode != BiometricAPI.BIOAPI_OK)
					{
						System.out.println("error: " + bio.errString(errCode) + " = bio.BioEnroll(handle, badgeNumber, (byte)index, bioscryptQuality)");
						continue;
					}
					System.out.println("content = " + bioscryptQuality.content);
					System.out.println("quality = " + bioscryptQuality.quality);
				}
			}
			else if (fromConsole.equals("2"))
			{
				System.out.println("badge number?");
				fromConsole = stdin.readLine();
				int badgeNumber;
				try {
					badgeNumber = Integer.parseInt(fromConsole);
				} catch (Exception ex) {
					System.out.println("bad badge number exception="+ex);
					continue;
				}
				System.out.println("Present finger to verify");
				errCode = bio.BioVerify(handle, badgeNumber);
				System.out.println("Verified Badge " + badgeNumber + " result = " + bio.errString(errCode));
			}
			else if (fromConsole.equals("3"))
			{
				System.out.println("Getting a list of all templates in the reader");
				errCode = bio.BioGetTemplateCount(handle, ip);
				if (errCode != BiometricAPI.BIOAPI_OK)
				{
					System.out.println("error: " + bio.errString(errCode) + " = bio.BioGetTemplateCount(handle, ip)");
					continue;
				}
				if (ip.i == 0)
				{
					System.out.println("no templates found");
					continue;
				}
				int count = ip.i;
				int [] badgeNumberList = new int [count];
				byte [] templateIndexList = new byte [count];
				errCode = bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip);
				if (errCode != BiometricAPI.BIOAPI_OK)
				{
					System.out.println("error: " + bio.errString(errCode) + " = bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)");
					continue;
				}
				System.out.println(ip.i + " templates found:");
				for (int i=0; i<count; i++) {
					System.out.println("(" + badgeNumberList[i] + ", " + templateIndexList[i] + ")");
				}
			}
			else if (fromConsole.equals("4"))
			{
				System.out.println("Enter badge number to delete:");
				fromConsole = stdin.readLine();
				int badgeNumber;
				try {
					badgeNumber = Integer.parseInt(fromConsole);
				} catch (Exception ex) {
					System.out.println("bad badge number exception="+ex);
					continue;
				}
			        int [] badgeNumberList = { badgeNumber };
				byte [] indexNumberList = null;
				errCode = bio.BioTemplateDelete(handle, badgeNumberList, indexNumberList);
				if (errCode != BiometricAPI.BIOAPI_OK)
				{
					System.out.println("error: " + bio.errString(errCode) + " = bio.BioTemplateDelete(handle, ip, badgeNumberList, indexNumberList)");
					continue;
				}
			}
		}
	}
}
