/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

package com.accu_time.test;

import com.accu_time.util.TextFileDeviceIO;
import com.accu_time.util.HardwareWatchdog;
import com.accu_time.util.SoftwareWatchdog;
import com.accu_time.util.Keypad;
import com.accu_time.util.Dbg;

public class TestTextFileDeviceIO {
	static TextFileDeviceIO leds;
	static TextFileDeviceIO cfgs;

    public static void main(String[] args) {
		leds = new TextFileDeviceIO("/dev/atsleds");
		cfgs = new TextFileDeviceIO("/dev/atsconfig");
		System.out.println("args.length="+args.length);
		for (int i=0; i<args.length; i++) {
			System.out.println("["+i+"]='"+args[i]+"'");
		}
		if (args.length==0 ||
		    (!args[0].equals("cfg") &&
			 !args[0].equals("java_sys") &&
		     !args[0].equals("sw_wdg") &&
		     !args[0].equals("hw_wdg") &&
			 !args[0].equals("key_rpt") &&
			 !args[0].equals("key_map") &&
		     !args[0].equals("sw_wdg_w_close"))) {
			System.out.println("usage: sh test.sh cfg|sw_wdg|hw_wdg|key_rpt|key_map|sw_wdg_w_close");
			return;
		}
		if (args[0].equals("cfg")) {
			System.out.println("Enable Dig Out 1 = " + leds.readValue("Enable Dig Out 1"));
			System.out.println("displaytype = " + cfgs.readValue("displaytype"));
			String tmp = cfgs.readValue("auxdev");
			System.out.println("auxdev was " + tmp);
			cfgs.writeValue("auxdev", "23");
			System.out.println("auxdev set to 23");
			String[][] pairs = cfgs.readAllPairs();
			for (int i=0; i<pairs.length; i++) {
				System.out.println("["+i+"] "+pairs[i][0]+" = "+pairs[i][1]);
			}
			cfgs.writeValue("auxdev", tmp);
			System.out.println("restored auxdev to " + cfgs.readValue("auxdev"));
			System.out.println("<end of pairs>");
		}
		if (args[0].equals("java_sys")) {
			java.util.Properties java_sys_properties = System.getProperties();
			java_sys_properties.list(System.out);
			System.out.println("java.library.path = " + System.getProperty("java.library.path"));
			System.out.println("com.ibm.oti.vm.bootstrap.library.path = " + System.getProperty("com.ibm.oti.vm.bootstrap.library.path"));
			System.out.println("java.fullversion = " + System.getProperty("java.fullversion"));
			System.out.println("java.vm.info = " + System.getProperty("java.vm.info"));
		}
		if (args[0].equals("sw_wdg") || args[0].equals("sw_wdg_w_close")) {
			SoftwareWatchdog watchdog = new SoftwareWatchdog(10);
			System.out.println("sw watchdog = " + watchdog);
			for (int i=0; i<60; i++) {
				watchdog.hit();
				Dbg.wait(1);
				System.out.print(".");
			}
			System.out.println("not hitting any longer");
			if (args[0].equals("sw_wdg_w_close")) {
				System.out.println("closing");
				watchdog.close();
			}
			Dbg.wait(20);
		}
		if (args[0].equals("hw_wdg")) {
			HardwareWatchdog watchdog = new HardwareWatchdog();
			System.out.println("hw watchdog = " + watchdog);
			for (int i=0; i<60; i++) {
				int err = watchdog.hit();
				if (err != 0) {
					Dbg.out("watchdog.hit() returned "+err);
				}
				Dbg.wait(1);
			}
			System.out.println("not hitting any longer");
			Dbg.wait(20);
		}
		if (args[0].equals("key_rpt")) {
			Keypad ku = new Keypad();
			int hold_down_msec = 3000;
			int repeat_msec = 25;
			try {
			  	if (args.length >= 2) {
			  		hold_down_msec = Integer.parseInt(args[1]);
				}
			  	if (args.length >= 3) {
			  		repeat_msec = Integer.parseInt(args[2]);
				}
			} catch (NumberFormatException ex) {
			};
			ku.setKeypadRepeatRate(hold_down_msec, repeat_msec);
		}
		if (args[0].equals("key_map")) {
			Keypad ku = new Keypad();
			char [][] keymap = ku.getKeypadMap();
			ku.displayKeypadMap(keymap);
			if (args.length==2 && args[1].indexOf("<") == 0) {
				ku.displayKeypadMap(ku.readKeypadDefFile(args[1].substring(1)));
			}
			if (args.length==2 && args[1].indexOf(">") == 0) {
				ku.writeKeypadDefFile(args[1].substring(1), ku.getKeypadMap());
			}
		}
	}
}
