/*
+====================================================================+
| Global Terminals                                                             |
|  Written by:  Bob Japenga/MicroTools                               |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/
/* A class for writing debug information to the system output, only if a flag is set */
/* Created by Mike Scudder of MicroTools, Inc. for Accu-time on 6 Feb 2007 */
package com.accu_time.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Dbg {
    // This class will silently discard all writes unless this boolean is changed to true.
	public static boolean outputDebugInfo = true;

    // No instance of this class should be needed; only the static methods should be used.
    private Dbg() {};

    // writes only if outputDebugInfo is true
    public static void w(String debugInfo) {
        if (outputDebugInfo) {
            System.out.println(debugInfo);
        }
    }

    // always writes
    public static void out(String debugInfo) {
        System.out.println(debugInfo);
    }

    public static void pst() {
        if (outputDebugInfo) {
            Thread.dumpStack();
        }
    }

    public static void pst(Exception ex) {
        if (outputDebugInfo) {
            ex.printStackTrace();
        }
    }

    public static void sysToFile(String path) {
        OutputStream osout = null;
        PrintStream os_ps = null;
        try {
            osout = (OutputStream)new FileOutputStream(path);
            os_ps = new PrintStream(osout);
            System.setOut(os_ps);
            System.setErr(os_ps);
        } catch (Exception ex) {
            System.out.println("Dbg.sysToFile error: " + ex);
            System.exit(-1);
        }
    }

	public static void wait(int seconds) {
		Object o = new Object();
		try {
			synchronized (o) {
				o.wait(seconds*1000);
			}
		}
		catch (Exception ex) {
		}
	}

	public static String toHex(char c) {
		byte highNibble = (byte)((c & 0xff)/0x10);
		byte lowNibble  = (byte)((c & 0xff)%0x10);
		char highHexDigit = (highNibble < 10)?(char)('0'+highNibble):(char)('a'+highNibble-10);
		char lowHexDigit = (lowNibble < 10)?(char)('0'+lowNibble):(char)('a'+lowNibble-10);
		return String.valueOf(highHexDigit) + String.valueOf(lowHexDigit);
	}

}
