/*
 * Copyright 2007 Accu-Time Systems, Inc.  All rights reserved.
 *
 *                            DISCLAIMER
 * NO WARRANTIES
 * Accu-Time Systems expressly disclaims any warranty for the SOFTWARE
 * PRODUCT. The SOFTWARE PRODUCT and any related documentation is
 * provided "as is" without warranty of any kind, either expressed or
 * implied, including, without limitation, the implied warranties or
 * merchantability, fitness for a particular purpose, or noninfringe-
 * ment. The entire risk arising out of the use or performance of the
 * SOFTWARE PRODUCT remains with the user.
 *
 * NO LIABILITY FOR DAMAGES.
 * Under no circumstances is Accu-Time Systems liable for any damages
 * whatsoever (including, without limitation, damages for loss of busi-
 * ness profits, business interruption, loss of business information,
 * or any other pecuniary loss) arising out of the use of or inability
 * to use this product.
 *
 */

/**
 * @file Badge.java
 *
 * @brief This file contains the com.accu_time.io.Badge class.
 *
 * @author Jeremy Slater, jslater@accu-time.com
 *
 * @date April 23, 2009 - initial version
 * @date May 14, 2009 - Badge does not store event related data
 */

package com.accu_time.device;

/** 
 * @class Badge
 *
 * @brief The Badge class stores identification card data for many card types.
 *
 * This class is used to store the following badge data:
 *  - decoded value
 *  - raw value
 */
public class Badge {
	private String _value;
	private String _raw;

	/**
	 * @brief Create a Badge object instance.
	 *
	 * The Badge constructor creates a new badge object that is designed to be 
	 * read only.  
	 * 
	 * @param value - The decoded badge number.
	 * @param raw - The raw badge data.
	 */
	public Badge(String value, String raw) {
		_value = value;
		_raw   = raw;
	}
	
	/**
	 * @brief Get the decoded value
	 */
	public String getValue() {
		return _value;
	}

	/**
	 * @brief Get the raw data
	 */
	public String getRaw() {
		return _raw;
	}
}

