
package com.accu_time.test;

import javax.net.ssl.*;
import javax.net.*;
import java.io.*;
import java.net.*;
import java.security.*;

public class ShowTrustStore {
	public static void main(String[] args) {
		String trustStore = System.getProperty("javax.net.ssl.trustStore");
		if(trustStore == null)
			System.out.println("javax.net.ssl.trustStore is not defined");
		else System.out.println("javax.net.ssl.trustStore = " + trustStore);
		try {
			System.out.println("TrustManagerAlgorithm " + TrustManagerFactory.getDefaultAlgorithm());
			TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
			System.out.println("Provider " + tmf.getProvider());
			KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
			System.out.println("Keystore " + ks + " provider " + ks.getProvider());
			ks.load(new FileInputStream("/release/optiplex.keystore.j9"), "storePassword".toCharArray());
			Key key = ks.getKey("optiplex_745", "keyPassword".toCharArray());
			System.out.println("key = " + key);
			System.out.println("ks.isKeyEntry(\"optiplex_745\") = " + ks.isKeyEntry("optiplex_745"));
			tmf.init(ks);
			TrustManager[] tms = tmf.getTrustManagers();
			for (int i=0; i<tms.length; i++) {
				System.out.println(" Trust Manager " + i + " = " + tms[i]);
			}
			TrustManager tm = tms[0];
			java.security.cert.X509Certificate[] certArray = ((X509TrustManager)tm).getAcceptedIssuers();
			for (int i=0; i<certArray.length; i++) {
				System.out.println(" Issuer " + i + " = " + certArray[i]);
			}
			String hostname = "192.168.0.165";
			int port = 10000;
			if (args.length >= 1) {
				hostname = args[0];
			}
			if (args.length >= 2) {
				port = Integer.parseInt(args[1]);
			}
			SocketFactory socketFactory = SSLSocketFactory.getDefault();
			Socket socket = socketFactory.createSocket(hostname, port);

			// Create streams to securely send and receive data to the server
			InputStream in = socket.getInputStream();

			// Read from in and write to out...
			char ch;
			int cnt = 0;
			System.out.println(hostname + ":" + port + " responded with:");
			while ((ch = (char)in.read()) != -1 && cnt < 256) {
				System.out.print(ch);
				cnt++;
			}
			System.out.println();

			// Close the socket
			in.close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
}
