/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

package com.accu_time.test;

import com.accu_time.util.BiometricAPI;
import com.accu_time.util.BiometricAPI.*;
import com.accu_time.util.BiometricAPIviaJNI;
import com.accu_time.util.Dbg;
import com.accu_time.util.MQ;
import java.io.*;

public class TestJavaAPILumidigm {
	private static BufferedReader stdin = new BufferedReader( new InputStreamReader( System.in ) );

    public static void main(String args[]) throws IOException, NumberFormatException {
		int errCode = BiometricAPI.BIOAPI_INVALID;
		int devType = -1;
		if (args.length >= 1 && args[0].equalsIgnoreCase("Cogent")) {
			devType = BiometricAPI.BIOAPI_COGENT;
		} else if (args.length >= 1 && args[0].equalsIgnoreCase("Bioscrypt")) {
			devType = BiometricAPI.BIOAPI_BIOSCRYPT;
		} else if (args.length >= 1 && args[0].equalsIgnoreCase("Suprema")) {
			devType = BiometricAPI.BIOAPI_SUPREMA;
		} else if (args.length >= 1 && args[0].equalsIgnoreCase("Lumidigm")) {
			devType = BiometricAPI.BIOAPI_LUMIDIGM;
		}

		if (devType == -1 ||
		    (args.length == 3 && ! args[1].equalsIgnoreCase("Flash"))) {
		    System.out.println("args length: " + args.length);
			System.out.println("Usage:\n" +
							   "sh test.sh BiometricAPIviaJNI Cogent|Bioscrypt|Suprema [flash flashFileName]");
			return;
		}
		BioscryptQuality_struct bioscryptQuality = new BioscryptQuality_struct();
		// Test all the above...
		System.loadLibrary("ATSJavaAPI");
		
		BiometricAPIviaJNI bio = new BiometricAPIviaJNI();
		IntPass ip = new IntPass();
		System.out.println(bio.errString(bio.BioInitialization(ip, devType, (byte)3)) + " = BioInitialization(ip, " + devType + ", (byte)4)");
		int handle = ip.i;
		System.out.println("handle=" + handle);
		System.out.println(bio.errString(bio.BioPowerOff(handle)) + " = bio.BioPowerOff(handle)");
		bio.wait(1); // give it time to really power off
		System.out.println(bio.errString(bio.BioPowerOn(handle)) + " = bio.BioPowerOn(handle)");
		bio.wait(2);
		System.out.println(bio.errString(bio.BioInitComPort(handle, 115200)) + " = bio.BioInitComPort(handle, 115200)");

		errCode = bio.BioDeviceResponsive(handle);
		System.out.println(bio.errString(errCode) + " = bio.BioDeviceResponsive(handle)");
		if (errCode != BiometricAPI.BIOAPI_OK) {
			System.out.println("Couldn't talk to fingerprint reader");
			return;
		}

		System.out.println("\n\nBiometric Reader Initialized and Is Responsive...");
		
		int count = ip.i;
		int [] badgeNumberList = new int [count];
		byte [] templateIndexList = new byte [count];
		BioDiagnostics_struct diag = new BioDiagnostics_struct();
/*
		//Get version information
		System.out.println("\nTest 1: Get Version Information");
		StringPass versionString = new StringPass();
		System.out.println(bio.errString(bio.BioGetVersionString(handle, versionString)) + " = bio.BioGetVersionString(handle, versionString)");
		System.out.println("versionString.s = " + versionString.s);		

		//Do Self Test
		System.out.println("\nTest 2: Preform Self Test");
		StringPass selfTestResult = new StringPass();
		System.out.println(bio.errString(bio.BioSelfTest(handle, selfTestResult)) + " = bio.BioSelfTest(handle, selfTestResult)");      
		System.out.println("selfTestResult.s = " + selfTestResult.s);
*/
		//Deleting all Templates
		System.out.println("\nTest 3: Deleting all templates");
		System.out.println(bio.errString(bio.BioTemplateDelete(handle, null, null)) + "= bio.BioTemplateDelete(handle, null, null)");

		//Getting Template Limit
		System.out.println(bio.errString(bio.BioGetTemplateLimit(handle, ip)) + "= bio.BioGetTemplateLimit(handle, ip)");
		System.out.println("limit = " + ip.i);

		System.out.println("\nStaring Enroll / Verify Process...");
		System.out.println("We are going to enroll 1 users, 2 templates each...");
		System.out.println("Waiting 5 seconds");
		bio.wait(5);
		BytePass bp = new BytePass();
		System.out.println();
		

		for (int i=100; i<=100; i++) {
		System.out.println("\nUser " + i);
		System.out.println("Present finger for enroll template 1");
		System.out.println();
		//Enroll Section		
		System.out.println(bio.errString(bio.BioEnroll(handle, i, (byte)0, bp)) + " = bio.BioEnroll(handle, " + i + ", (byte)0, bp)");
		System.out.println("quality = " + bp.b);
		System.out.println("remove finger");

		System.out.println("Present finger for enroll template 2");
		System.out.println();
		//Enroll Section		
		System.out.println(bio.errString(bio.BioEnroll(handle, i, (byte)1, bp)) + " = bio.BioEnroll(handle, " + i + ", (byte)1, bp)");
		System.out.println("quality = " + bp.b);
		System.out.println("remove finger");
		bio.wait(2);
		}

		//After the enroll, list out all templates found
		System.out.println("Getting a list of all templates in the reader");
		System.out.println(bio.errString(bio.BioGetTemplateCount(handle, ip)) + "= bio.BioGetTemplateCount(handle, ip)");
		count = ip.i;
		badgeNumberList = new int [count];
		templateIndexList = new byte [count];
		System.out.println(bio.errString(bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)) + "= bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)");
		System.out.println(ip.i + " templates found");
		for (int i=0; i<count; i++) {
		System.out.println("(" + badgeNumberList[i] + ", " + templateIndexList[i] + ")");
		}

		//Getting Template Limit
		System.out.println(bio.errString(bio.BioGetTemplateLimit(handle, ip)) + "= bio.BioGetTemplateLimit(handle, ip)");
		System.out.println("Template limit (num left)= " + ip.i);


		//Verify Section
		System.out.println("present user 100 finger for verify");
		System.out.println(bio.errString(bio.BioVerify(handle, 100)) + " = bio.BioVerify(handle, 100)");
		System.out.println();

		System.out.println("present user 100 other finger for verify");
		System.out.println(bio.errString(bio.BioVerify(handle, 100)) + " = bio.BioVerify(handle, 100)");
		System.out.println();

/*
		//Do Biodiagnostics
		System.out.println("\nTest 4: Preform BioDiagnostics");
		
		System.out.println(bio.errString(bio.BioDiagnostics(handle, diag)) + "= bio.bio.BioDiagnostics(handle, diag)");
		System.out.println("diag.badEnrolls=" + diag.badEnrolls + " .validEnrolls=" + diag.validEnrolls);
		System.out.println("    .badReads=" + diag.badReads + " .validReads=" + diag.validReads);
		System.out.println("    .powerCycleCount=" + diag.powerCycleCount + " .powerCycleTime=" + diag.powerCycleTime);
		System.out.println("Getting a list of all templates in the reader");
		System.out.println(bio.errString(bio.BioGetTemplateCount(handle, ip)) + "= bio.BioGetTemplateCount(handle, ip)");
		count = ip.i;
		badgeNumberList = new int [count];
		templateIndexList = new byte [count];
		System.out.println(bio.errString(bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)) + "= bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)");
		System.out.println(ip.i + " templates found");
		for (int i=0; i<count; i++) {
		System.out.println("(" + badgeNumberList[i] + ", " + templateIndexList[i] + ")");
		}
*/
		//Test Enroll Template
		byte [] template = {};
		if (devType == BiometricAPI.BIOAPI_COGENT) {		
			template = new byte [BiometricAPI.COGENT_TEMPLATE_SIZE];
		} else if (devType == BiometricAPI.BIOAPI_SUPREMA) {
			template = new byte [BiometricAPI.SUPREMA_TEMPLATE_SIZE];
		} else if (devType == BiometricAPI.BIOAPI_LUMIDIGM) {
			template = new byte [BiometricAPI.LUMIDIGM_TEMPLATE_SIZE];
		}
		if (devType == BiometricAPI.BIOAPI_COGENT || devType == BiometricAPI.BIOAPI_SUPREMA || devType == BiometricAPI.BIOAPI_LUMIDIGM) {
			System.out.println("Present Different Finger for BioEnrollTemplate Test:");			
			errCode = bio.BioEnrollTemplate(handle, 99, (byte)0, bp, template);
			System.out.println(bio.errString(errCode) + " = bio.BioEnrollTemplate(handle, 99, (byte)0, bp, template)");
		}

		//Test BIOGETENROLLQULITY
		//System.out.println(bio.errString(bio.BioGetEnrollQuality(handle, ip, bp)) + " = bio.BioGetEnrollQuality(handle, ip, bp)");
		//System.out.println("badge 99 quality = " + bp.b);


		System.out.println("Now Present same finger for VerifyTemplate Test:");
		bio.wait(2);
		System.out.println("present badge 99 finger for verify");
		System.out.println(bio.errString(bio.BioVerifyTemplate(handle, 99, template)) + " = bio.BioVerifyTemplate(handle, 99, template)");
		System.out.println();
		System.out.println(bio.errString(bio.BioGetVerifyScore(handle, 99, bp)) + " = bio.BioGetVerifyScore(handle, 99, bp)");
		System.out.println("score = " + bp.b);


		// exercise identify mode

		int badgeNumber;
		String mq_name = "/BiometricAPIviaJNI.mq";
		errCode = bio.BioSetModeIdentify(handle, mq_name);
		System.out.println(bio.errString(errCode) + "= bio.BioSetModeIdentify(handle, " + mq_name + ")");
		if (errCode == BiometricAPI.BIOAPI_OK) {
			try {
				MQ mq = new MQ();
				final int identificationModeSeconds = 30;
				System.out.println("All identifications in the next " + identificationModeSeconds +
				                   " seconds will be reported");
				BioVerificationReport_struct idStruct = new BioVerificationReport_struct();
				long startAt = System.currentTimeMillis();
				long now = startAt;
				boolean interruptShown = false;
				boolean pauseCompleted = false;
				int mqdes = mq.mq_open(mq_name, mq.O_RDONLY | mq.O_NONBLOCK);
				if (mqdes == -1) {
					throw new Exception("mq_open failure errno = " + mq.errno);
				}
				MQ.mq_attr_struct mq_attr = mq.new mq_attr_struct();
				if (mq.mq_getattr(mqdes, mq_attr) != 0) {
					throw new Exception("mq_getattr failure errno = " + mq.errno);
				}
				do {
					if (!interruptShown &&
					    now - startAt > identificationModeSeconds * 1000 / 3) {
						System.out.println("Interrupting identify mode to get a count");
						System.out.println(bio.errString(bio.BioGetTemplateCount(handle, ip)) + "= bio.BioGetTemplateCount(handle, ip)");
						System.out.println(ip.i + " templates left in the device");
						interruptShown = true;

						System.out.println("\nUser 200");
						System.out.println("Present finger for enroll template 1");
						System.out.println();
						//Enroll Section		
						System.out.println(bio.errString(bio.BioEnroll(handle, 200, (byte)0, bp)) + " = bio.BioEnroll(handle, 200, (byte)0, bp)");
						System.out.println("quality = " + bp.b);
						System.out.println("remove finger");

						System.out.println("Present finger for enroll template 2");
						System.out.println();
						//Enroll Section		
						System.out.println(bio.errString(bio.BioEnroll(handle, 200, (byte)1, bp)) + " = bio.BioEnroll(handle, 200, (byte)1, bp)");
						System.out.println("quality = " + bp.b);
						System.out.println("remove finger");
						bio.wait(2);


					}
					if (!pauseCompleted &&
						now - startAt > 2 * identificationModeSeconds * 1000 / 3) {
						System.out.println("Pausing identification mode for 5 seconds");
						System.out.println(bio.errString(bio.BioSetModeVerify(handle)) + "= bio.BioSetVerifyMode(handle)");
						System.out.println(bio.errString(bio.BioDiagnostics(handle, diag)) + "= bio.bio.BioDiagnostics(handle, diag)");
						System.out.println("diag.badEnrolls=" + diag.badEnrolls + " .validEnrolls=" + diag.validEnrolls);
						System.out.println("    .badReads=" + diag.badReads + " .validReads=" + diag.validReads);
						System.out.println("    .powerCycleCount=" + diag.powerCycleCount + " .powerCycleTime=" + diag.powerCycleTime);
						System.out.println("Getting a list of all templates in the reader");
						System.out.println(bio.errString(bio.BioGetTemplateCount(handle, ip)) + "= bio.BioGetTemplateCount(handle, ip)");
						count = ip.i;
				        badgeNumberList = new int [count];
						templateIndexList = new byte [count];
						System.out.println(bio.errString(bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)) + "= bio.BioGetAllTemplateIds(handle, badgeNumberList, templateIndexList, ip)");
						System.out.println(ip.i + " templates found");
						for (int i=0; i<count; i++) {
							System.out.println("(" + badgeNumberList[i] + ", " + templateIndexList[i] + ")");
						}
						bio.wait(5);
						System.out.println("Resuming identification mode");
						System.out.println(bio.errString(bio.BioSetModeIdentify(handle, mq_name)) + "= bio.BioSetModeIdentify(handle, " + mq_name + ")");
						pauseCompleted = true;
					}
					byte [] buffer = new byte [(int)mq_attr.mq_msgsize];
					mq.errno = 0;
					int msgSize = mq.mq_receive(mqdes, buffer);
					if (mq.errno != 0 && mq.errno != mq.EAGAIN) {
						throw new Exception("mq_receive failure errno = " + mq.errno);
					}
					if (mq.errno == mq.EAGAIN) {
						bio.waitMilli(100); // wait a 10th of a second
					} else {
						if (msgSize < 3) {
							throw new Exception("invalid message (len = " + msgSize + ")");
						}
						if (buffer[msgSize-1] != 0) {
							throw new Exception("badge number string in message not terminated");
						}
						idStruct.score = buffer[0];
						idStruct.index = buffer[1];
 						int nullFoundAt = -1;
						for (int i=0; i<msgSize-2; i++) {
							idStruct.badge[i] = buffer[2+i];
							if (buffer[2+i] == 0) {
								nullFoundAt = i;
								break;
							}
						}
						System.out.println();
						String badgeNumberString = new String(idStruct.badge, 0, nullFoundAt, "US-ASCII");
						System.out.println("badgeNumberString = " + badgeNumberString + " len = " + badgeNumberString.length());
						if (badgeNumberString.equals("")) {
							System.out.print("Saw failed identification attempt (code " + idStruct.index + ")");
						} else {
							badgeNumber = Integer.parseInt(badgeNumberString);
							System.out.print("saw badge " + badgeNumber + " index " + idStruct.index + " score " + idStruct.score);
						}
						System.out.println(" after " + (now-startAt)/1000 + "." + (now-startAt)%1000 + " seconds");
					}
					now = System.currentTimeMillis();
				} while (now-startAt < identificationModeSeconds*1000);
				System.out.println("Exiting identification mode");
				System.out.println(bio.errString(bio.BioSetModeIdentify(handle, null)) + "= bio.BioSetModeIdentify(handle, null)");
				mq.mq_unlink(mq_name);
			} catch (Exception ex) {
				System.out.println("Exception " + ex + " encountered trying to use Identify mode");
				ex.printStackTrace();
			}
		}
	
		System.out.println(bio.errString(bio.BioSetModeVerify(handle)) + "= bio.BioSetVerifyMode(handle)");
		System.out.println("present user 100 finger for verify");
		System.out.println(bio.errString(bio.BioVerify(handle, 100)) + " = bio.BioVerify(handle, 100)");
		System.out.println();

		System.out.println("Getting templates (100,0) and (100, 1)");
		badgeNumberList = new int [] {100,100};
		templateIndexList = new byte [] {0, 1};
		byte [][] templateList = {};
		if (devType == BiometricAPI.BIOAPI_COGENT) {
			templateList = new byte [2][BiometricAPI.COGENT_TEMPLATE_SIZE];
		} else if (devType == BiometricAPI.BIOAPI_SUPREMA) {
			templateList = new byte [2][BiometricAPI.SUPREMA_TEMPLATE_SIZE];
		} else if (devType == BiometricAPI.BIOAPI_LUMIDIGM) {
			templateList = new byte [2][BiometricAPI.LUMIDIGM_TEMPLATE_SIZE];
		}
		errCode = bio.BioGetTemplates(handle, badgeNumberList, templateIndexList, templateList);
		System.out.println(bio.errString(errCode) + "= bio.BioGetTemplates(handle, badgeNumberList, templateIndexList, bioTemplateList)");
		if (errCode == BiometricAPI.BIOAPI_OK) {
			for (int i=0; i<2; i++) {
				if (templateList[i] == null) {
					System.out.println("template (" + badgeNumberList[i] + ", " + templateIndexList[i] + ") not found");
					continue;
				}
				for (int j=0; j<2; j++) {
					System.out.print("template(" + badgeNumberList[i] + ", " + templateIndexList[i] + ")[" + Dbg.toHex((char)(j*16)) + ".." + Dbg.toHex((char)(j*128+15)) + "] = ");
					for (int k=0; k<128; k++) {
						System.out.print(Dbg.toHex((char)templateList[i][j*16+k]) + " ");
					}
					System.out.println();
				}
			}
		}

		//Now that we have a template we should delete all on the device
		//Deleting all Templates
		System.out.println("\nDeleting all templates");
		System.out.println(bio.errString(bio.BioTemplateDelete(handle, null, null)) + "= bio.BioTemplateDelete(handle, null, null)");

		//Now we should do a put template
		System.out.println("\nPutting Template on the device");
		System.out.println(bio.errString(bio.BioPutTemplates(handle, templateList)) + "= bio.BioPutTemplates(handle, templateList)");
		

		//Now we should do a put template
		System.out.println("\nDoing a verify Against template on device");
		System.out.println(bio.errString(bio.BioSetModeVerify(handle)) + "= bio.BioSetVerifyMode(handle)");
		System.out.println("present user 100 finger for verify");
		System.out.println(bio.errString(bio.BioVerify(handle, 100)) + " = bio.BioVerify(handle, 100)");
		System.out.println();






	}
}
