/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

package com.accu_time.util;

import java.io.*;

public class BiometricAPIviaJNI implements BiometricAPI {

	static {
	  System.loadLibrary("ATSJavaAPI");
	}

	public native int BioInitialization(IntPass handle, int deviceType, byte comPort);

	public native int BioInitComPort(int handle, int baudRate);

	public native int BioPowerOn(int handle);

	public native int BioPowerOff(int handle);

	static native int BioDiagnosticsJNI(int handle, BioDiagnostics_struct diagnostics, byte [] globalTimeStamp);

	public int BioDiagnostics(int handle, BioDiagnostics_struct diagnostics) {
		byte [] globalTimeStamp = new byte [12];   //	time stamp "YYMMDDHHMMSS"
		int retCode = BioDiagnosticsJNI(handle, diagnostics, globalTimeStamp);
		if (globalTimeStamp[0] == 0) {
			diagnostics.powerCycleTime = 0;
			return retCode;
		}
		int year = 2000 + 10*(globalTimeStamp[0]-(byte)'0') + (globalTimeStamp[1]-(byte)'0');
		int monthOfYear = 10*(globalTimeStamp[2]-(byte)'0') + (globalTimeStamp[3]-(byte)'0');
		int dayOfMonth = 10*(globalTimeStamp[4]-(byte)'0') + (globalTimeStamp[5]-(byte)'0');
		int hourOfDay = 10*(globalTimeStamp[6]-(byte)'0') + (globalTimeStamp[7]-(byte)'0');
		int minuteOfHour = 10*(globalTimeStamp[8]-(byte)'0') + (globalTimeStamp[9]-(byte)'0');
		int secondOfMinute = 10*(globalTimeStamp[10]-(byte)'0') + (globalTimeStamp[11]-(byte)'0');
		diagnostics.powerCycleTime = (new TimeStampGregorian(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute)).timeStampGregorian();
		return retCode;
	}

	public native int BioSelfTest(int handle, StringPass selfTestResult);

	public native int BioDeviceResponsive(int handle);

	public native int BioGetVersionString(int handle, StringPass versionString);

	public native int BioGetDeviceSubType(int handle, IntPass deviceSubType);

	public native int BioFlashLoad(int handle, byte [] programRecord, IntPass recordNumber, IntPass done);

	public native int BioEnroll(int handle, int badgeNumber, byte templateIndex, BioscryptQuality_struct quality);
	public native int BioEnroll(int handle, int badgeNumber, byte templateIndex, BytePass quality);  // for Cogen

	public native int BioGetEnrollQuality(int handle, IntPass badgeNumber, BioscryptQuality_struct quality);
	public native int BioGetEnrollQuality(int handle, IntPass badgeNumber, BytePass quality);  // for Cogent

	public native int BioEnrollTemplate(int handle, int badgeNumber, byte templateIndex, BioscryptQuality_struct quality, byte [] template);
	public native int BioEnrollTemplate(int handle, int badgeNumber, byte templateIndex, BytePass quality, byte [] template);  // for Cogent

	public native int BioVerify(int handle, int badgeNumber);

	public native int BioVerifyTemplate(int handle, int badgeNumber, byte [] template);

	public native int BioVerifyAgainstTemplates(int handle, byte [][] bioTemplateList);

	public native int BioGetVerifyScore(int handle, int badgeNumber, BytePass score);

	public native int BioGetTemplates(int handle, int [] badgeNumberList, byte [] templateIndexList, byte [][]bioTemplateList);

	public native int BioPutTemplates(int handle, byte [][] bioTemplateList);

	public native int BioGetTemplateCount(int handle, IntPass count);

	public native int BioGetTemplateLimit(int handle, IntPass limit);

	public native int BioGetAllTemplateIds(int handle, int [] badgeNumberList, byte [] templateIndexList, IntPass count);

	public native int BioAreTemplateIdsPresent(int handle, int [] badgeNumberList, byte [] templateIndexList, IntPass present);

	public native int BioTemplateDelete(int handle, int [] badgeNumberList, byte [] templateIndexList);

	public native int BioSetTemplateSecurity(int handle, int [] badgeNumberList, byte [] templateIndexList, byte verificationThreshold);

	public native int BioSetModeIdentify(int handle, String bioMsgQueueName);

	public native int BioSetModeVerify(int handle);

	public native int BioCalibrate(int handle);
	
	public native int BioThreshold(int handle, int threshold);
	
	public native int BioGetThreshold(int handle, IntPass threshold);

	public void wait(int seconds) {
		waitMilli(seconds*1000);
	}

	public void waitMilli(int milliseconds) {
		Object o = new Object();
		try {
			synchronized (o) {
				o.wait(milliseconds);
			}
		}
		catch (Exception ex) {
		}
	}

	public String errString(int errCode) {
		return BioAPI_errMsgs[-errCode];
	}

    public static void main(String args[]) throws IOException, NumberFormatException {
		System.out.println("To test these API functions use:\n" +
						   "sh test.sh TestJavaAPI Cogent|Bioscrypt|Suprema|lumidigm [flash flashFileName]");
		return;
	}
}
