/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
| © 2011 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

// A JLabel that displays the time and date
// Created by Mike Scudder of MicroTools, Inc. for Accu-time on 14 Nov 2011
package com.accu_time.util;

import javax.swing.*;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;

public class ClockLabel extends JLabel implements ActionListener {
    SimpleDateFormat clockDateTimeFormat;
    
    public ClockLabel() {
        super("", javax.swing.SwingConstants.CENTER);
        String[] ampm = {"am", "pm"};
        clockDateTimeFormat = new SimpleDateFormat("MMM d, yyyy h:mm:ss a ");
        DateFormatSymbols dfs = clockDateTimeFormat.getDateFormatSymbols();
        dfs.setAmPmStrings(ampm);
        clockDateTimeFormat.setDateFormatSymbols(dfs);
        Date now = new Date();
        this.setText(clockDateTimeFormat.format(now));
        new Timer(1000, this).start();
    }
    
    public void actionPerformed(ActionEvent evt)
    {
        Date now = new Date();
        this.setText(clockDateTimeFormat.format(now));
        this.invalidate();
    }
}
