/*
+====================================================================+
|Global Terminal                                                             |
|  Written by:  Mike Scudder/MicroTools                               |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/
// This class enables the hardware watchdog timer and reset.
//
// A watchdog timer must be hit, repeatedly.  Each hit resets the timer.  If the
// timer ever expires, the system will reboot.  It is used to provide a safety
// net for a program: if the program stops hitting the watchdog, it is presumed
// to have lost its way and the reboot restores the system to proper operation.
//
// The Global comes with a hardware watchdog with a 1.5 second timeout.  If the
// appropriate jumper is in place, and an instance of this class is created, the
// hardware watchdog is enabled.  Thereafter, the watchdog must be hit repeatedly
// with never more than 1.5 seconds between hits, or the system will reboot.

package com.accu_time.util;

public class HardwareWatchdog {
	static {
	  System.loadLibrary("ATSJavaAPI");
	}

	public HardwareWatchdog() {
		int errno =
		watchdogOpen();
		if (errno != 0) {
			System.out.println("watchdogOpen() failure errno=" + errno);
		}
	}
    public native int hit();
	public native int watchdogOpen();
}		
