/*
+====================================================================+
|Global Terminal                                                     |
|  Written by:  Mike Scudder/MicroTools                              |
+====================================================================+
|                                                                    |
|  2007 Accu-Time Systems, Inc.  All rights reserved.               |
|                                                                    |
|====================================================================+
|                                                                    |
|                       DISCLAIMER                                   |
|NO WARRANTIES                                                       |
|Accu-Time Systems expressly disclaims any warranty for the SOFTWARE |
|PRODUCT. The SOFTWARE PRODUCT and any related documentation is      |
|provided "as is" without warranty of any kind, either expressed or  |
|implied, including, without limitation, the implied warranties or   |
|merchantability, fitness for a particular purpose, or noninfringe-  |
|ment. The entire risk arising out of the use or performance of the  |
|SOFTWARE PRODUCT remains with the user.                             |
|                                                                    |
|NO LIABILITY FOR DAMAGES.                                           |
|Under no circumstances is Accu-Time Systems liable for any damages  |
|whatsoever (including, without limitation, damages for loss of busi-|
|ness profits, business interruption, loss of business information,  |
|or any other pecuniary loss) arising out of the use of or inability |
|to use this product.                                                |
|                                                                    |
+====================================================================+
*/

// Documentation:
//
// This is a pretty straightforward port of enough of the message queue
// C library calls to use the Biometric API identify mode queues.
//
package com.accu_time.util;

public class MQ {
	public class mq_attr_struct {
		public long mq_flags;
		public long mq_maxmsg;
		public long mq_msgsize;
		public long mq_curmsgs;
		public mq_attr_struct() {
			mq_flags = 0;
			mq_maxmsg = 0;
			mq_msgsize = 0;
			mq_curmsgs = 0;
		}
	}

	// Since these may vary between systems, they are retrieved when this
	// wrapper object is initialized.
	public int O_RDONLY;
	public int O_WRONLY;
	public int O_RDWR;
	public int O_CREAT;
	public int O_EXCL;
	public int O_NONBLOCK;

	public int EAGAIN;
	public int	EXIST;
	public int	ENOENT;
	public int	EACCES;

	public int errno = 0;

    public MQ() {
		errno = 0;
		int [] cSymbols = new int [9];
		get_cSymbols(cSymbols);
		int i=0;
		O_RDONLY = cSymbols[i++];
		O_WRONLY = cSymbols[i++];
		O_RDWR = cSymbols[i++];
		O_CREAT = cSymbols[i++];
		O_EXCL = cSymbols[i++];
		O_NONBLOCK = cSymbols[i++];
		EAGAIN = cSymbols[i++];
		ENOENT = cSymbols[i++];
		EACCES = cSymbols[i++];
	}


	public native void get_cSymbols(int [] symbolValues);

	public native int mq_close(int mqdes);
	public native int mq_getattr(int mqdes, mq_attr_struct mq_attr);
	public native int mq_open(String mqname, int oflag);
	public native int mq_receive(int mqdes, byte [] msg);
	public native int mq_unlink(String mqname);
}
